/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.NodeType;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.model.WorkerHeartBeat;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.entity.WorkerGroup;
import org.apache.dolphinscheduler.dao.mapper.WorkerGroupMapper;
import org.apache.dolphinscheduler.registry.api.Event;
import org.apache.dolphinscheduler.registry.api.SubscribeListener;
import org.apache.dolphinscheduler.remote.utils.NamedThreadFactory;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.registry.WorkerInfoChangeListener;
import org.apache.dolphinscheduler.service.queue.MasterPriorityQueue;
import org.apache.dolphinscheduler.service.registry.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServerNodeManager
implements InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(ServerNodeManager.class);
    private final Lock masterLock = new ReentrantLock();
    private final ReentrantReadWriteLock workerGroupLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock workerGroupReadLock = this.workerGroupLock.readLock();
    private final ReentrantReadWriteLock.WriteLock workerGroupWriteLock = this.workerGroupLock.writeLock();
    private final ReentrantReadWriteLock workerNodeInfoLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock workerNodeInfoReadLock = this.workerNodeInfoLock.readLock();
    private final ReentrantReadWriteLock.WriteLock workerNodeInfoWriteLock = this.workerNodeInfoLock.writeLock();
    private final ConcurrentHashMap<String, Set<String>> workerGroupNodes = new ConcurrentHashMap();
    private final Set<String> masterNodes = new HashSet<String>();
    private final Map<String, WorkerHeartBeat> workerNodeInfo = new HashMap<String, WorkerHeartBeat>();
    private ScheduledExecutorService executorService;
    @Autowired
    private RegistryClient registryClient;
    @Autowired
    private WorkerGroupMapper workerGroupMapper;
    private final MasterPriorityQueue masterPriorityQueue = new MasterPriorityQueue();
    @Autowired
    private AlertDao alertDao;
    @Autowired
    private MasterConfig masterConfig;
    private final List<WorkerInfoChangeListener> workerInfoChangeListeners = new ArrayList<WorkerInfoChangeListener>();
    private volatile int currentSlot = 0;
    private volatile int totalSlot = 0;

    public int getSlot() {
        return this.currentSlot;
    }

    public int getMasterSize() {
        return this.totalSlot;
    }

    public void afterPropertiesSet() {
        this.updateMasterNodes();
        this.updateWorkerNodes();
        this.updateWorkerGroupMappings();
        this.executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("ServerNodeManagerExecutor"));
        this.executorService.scheduleWithFixedDelay(new WorkerNodeInfoAndGroupDbSyncTask(), 0L, this.masterConfig.getWorkerGroupRefreshInterval().getSeconds(), TimeUnit.SECONDS);
        this.registryClient.subscribe("/nodes/master", (SubscribeListener)new MasterDataListener());
        this.registryClient.subscribe("/nodes/worker", (SubscribeListener)new WorkerDataListener());
    }

    protected Set<String> getWorkerAddressByWorkerGroup(Map<String, String> newWorkerNodeInfo, WorkerGroup wg) {
        String[] addrs;
        HashSet<String> nodes = new HashSet<String>();
        for (String addr : addrs = wg.getAddrList().split(",")) {
            if (!newWorkerNodeInfo.containsKey(addr)) continue;
            nodes.add(addr);
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMasterNodes() {
        this.currentSlot = 0;
        this.totalSlot = 0;
        this.masterNodes.clear();
        String nodeLock = "/lock/masters";
        try {
            this.registryClient.getLock(nodeLock);
            Collection currentNodes = this.registryClient.getMasterNodesDirectly();
            List masterNodes = this.registryClient.getServerList(NodeType.MASTER);
            this.syncMasterNodes(currentNodes, masterNodes);
        }
        catch (Exception e) {
            this.logger.error("update master nodes error", (Throwable)e);
        }
        finally {
            this.registryClient.releaseLock(nodeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWorkerNodes() {
        this.workerGroupWriteLock.lock();
        try {
            Map workerNodeMaps = this.registryClient.getServerMaps(NodeType.WORKER);
            for (Map.Entry entry : workerNodeMaps.entrySet()) {
                this.workerNodeInfo.put((String)entry.getKey(), (WorkerHeartBeat)JSONUtils.parseObject((String)((String)entry.getValue()), WorkerHeartBeat.class));
            }
        }
        finally {
            this.workerGroupWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWorkerGroupMappings() {
        List workerGroups = this.workerGroupMapper.queryAllWorkerGroup();
        HashMap<String, Set<Object>> tmpWorkerGroupMappings = new HashMap<String, Set<Object>>();
        try {
            this.workerNodeInfoReadLock.lock();
            for (WorkerGroup workerGroup : workerGroups) {
                String workerGroupName = workerGroup.getName();
                Object[] workerAddresses = workerGroup.getAddrList().split(",");
                if (ArrayUtils.isEmpty((Object[])workerAddresses)) continue;
                Set activeWorkerNodes = Arrays.stream(workerAddresses).filter(this.workerNodeInfo::containsKey).collect(Collectors.toSet());
                tmpWorkerGroupMappings.put(workerGroupName, activeWorkerNodes);
            }
            if (!tmpWorkerGroupMappings.containsKey("default")) {
                tmpWorkerGroupMappings.put("default", this.workerNodeInfo.keySet());
            }
        }
        finally {
            this.workerNodeInfoReadLock.unlock();
        }
        this.workerGroupWriteLock.lock();
        try {
            this.workerGroupNodes.clear();
            this.workerGroupNodes.putAll(tmpWorkerGroupMappings);
            this.notifyWorkerInfoChangeListeners();
        }
        finally {
            this.workerGroupWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncMasterNodes(Collection<String> nodes, List<Server> masterNodes) {
        this.masterLock.lock();
        try {
            this.masterNodes.addAll(nodes);
            this.masterPriorityQueue.clear();
            this.masterPriorityQueue.putList(masterNodes);
            int index = this.masterPriorityQueue.getIndex(this.masterConfig.getMasterAddress());
            if (index >= 0) {
                this.totalSlot = nodes.size();
                this.currentSlot = index;
            } else {
                this.logger.warn("Current master is not in active master list");
            }
            this.logger.info("Update master nodes, total master size: {}, current slot: {}", (Object)this.totalSlot, (Object)this.currentSlot);
        }
        finally {
            this.masterLock.unlock();
        }
    }

    public Map<String, Set<String>> getWorkerGroupNodes() {
        this.workerGroupReadLock.lock();
        try {
            Map<String, Set<String>> map = Collections.unmodifiableMap(this.workerGroupNodes);
            return map;
        }
        finally {
            this.workerGroupReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getWorkerGroupNodes(String workerGroup) {
        this.workerGroupReadLock.lock();
        try {
            Set<String> nodes;
            if (StringUtils.isEmpty((CharSequence)workerGroup)) {
                workerGroup = "default";
            }
            if (CollectionUtils.isEmpty(nodes = this.workerGroupNodes.get(workerGroup))) {
                Set<String> set = Collections.emptySet();
                return set;
            }
            Set<String> set = Collections.unmodifiableSet(nodes);
            return set;
        }
        finally {
            this.workerGroupReadLock.unlock();
        }
    }

    public Map<String, WorkerHeartBeat> getWorkerNodeInfo() {
        return Collections.unmodifiableMap(this.workerNodeInfo);
    }

    public Optional<WorkerHeartBeat> getWorkerNodeInfo(String workerServerAddress) {
        this.workerNodeInfoReadLock.lock();
        try {
            Optional<Object> optional = Optional.ofNullable(this.workerNodeInfo.getOrDefault(workerServerAddress, null));
            return optional;
        }
        finally {
            this.workerNodeInfoReadLock.unlock();
        }
    }

    private void syncSingleWorkerNodeInfo(String workerAddress, WorkerHeartBeat info) {
        this.workerNodeInfoWriteLock.lock();
        try {
            this.workerNodeInfo.put(workerAddress, info);
        }
        finally {
            this.workerNodeInfoWriteLock.unlock();
        }
    }

    public synchronized void addWorkerInfoChangeListener(WorkerInfoChangeListener listener) {
        this.workerInfoChangeListeners.add(listener);
    }

    private void notifyWorkerInfoChangeListeners() {
        Map<String, Set<String>> workerGroupNodes = this.getWorkerGroupNodes();
        Map<String, WorkerHeartBeat> workerNodeInfo = this.getWorkerNodeInfo();
        for (WorkerInfoChangeListener listener : this.workerInfoChangeListeners) {
            listener.notify(workerGroupNodes, workerNodeInfo);
        }
    }

    @PreDestroy
    public void destroy() {
        this.executorService.shutdownNow();
    }

    class MasterDataListener
    implements SubscribeListener {
        MasterDataListener() {
        }

        public void notify(Event event) {
            String path = event.path();
            Event.Type type = event.type();
            if (ServerNodeManager.this.registryClient.isMasterPath(path)) {
                try {
                    if (type.equals((Object)Event.Type.ADD)) {
                        ServerNodeManager.this.logger.info("master node : {} added.", (Object)path);
                        ServerNodeManager.this.updateMasterNodes();
                    }
                    if (type.equals((Object)Event.Type.REMOVE)) {
                        ServerNodeManager.this.logger.info("master node : {} down.", (Object)path);
                        ServerNodeManager.this.updateMasterNodes();
                        ServerNodeManager.this.alertDao.sendServerStoppedAlert(1, path, "MASTER");
                    }
                }
                catch (Exception ex) {
                    ServerNodeManager.this.logger.error("MasterNodeListener capture data change and get data failed.", (Throwable)ex);
                }
            }
        }
    }

    class WorkerDataListener
    implements SubscribeListener {
        WorkerDataListener() {
        }

        public void notify(Event event) {
            String path = event.path();
            Event.Type type = event.type();
            String data = event.data();
            if (ServerNodeManager.this.registryClient.isWorkerPath(path)) {
                try {
                    String[] parts = path.split("/");
                    String workerAddress = parts[parts.length - 1];
                    ServerNodeManager.this.logger.debug("received subscribe event : {}", (Object)event);
                    if (type == Event.Type.ADD) {
                        ServerNodeManager.this.logger.info("Worker: {} added, currentNode : {}", (Object)path, (Object)workerAddress);
                    } else if (type == Event.Type.REMOVE) {
                        ServerNodeManager.this.logger.info("Worker node : {} down.", (Object)path);
                        ServerNodeManager.this.alertDao.sendServerStoppedAlert(1, path, "WORKER");
                    } else if (type == Event.Type.UPDATE) {
                        ServerNodeManager.this.syncSingleWorkerNodeInfo(workerAddress, (WorkerHeartBeat)JSONUtils.parseObject((String)data, WorkerHeartBeat.class));
                    }
                }
                catch (Exception ex) {
                    ServerNodeManager.this.logger.error("WorkerGroupListener capture data change and get data failed", (Throwable)ex);
                }
            }
        }
    }

    class WorkerNodeInfoAndGroupDbSyncTask
    implements Runnable {
        WorkerNodeInfoAndGroupDbSyncTask() {
        }

        @Override
        public void run() {
            try {
                ServerNodeManager.this.updateWorkerNodes();
                ServerNodeManager.this.updateWorkerGroupMappings();
                ServerNodeManager.this.notifyWorkerInfoChangeListeners();
            }
            catch (Exception e) {
                ServerNodeManager.this.logger.error("WorkerNodeInfoAndGroupDbSyncTask error:", (Throwable)e);
            }
        }
    }
}

