/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.enums.SlotCheckState;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.repository.ProcessInstanceDao;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.dispatch.executor.NettyExecutorManager;
import org.apache.dolphinscheduler.server.master.event.WorkflowEvent;
import org.apache.dolphinscheduler.server.master.event.WorkflowEventQueue;
import org.apache.dolphinscheduler.server.master.event.WorkflowEventType;
import org.apache.dolphinscheduler.server.master.exception.MasterException;
import org.apache.dolphinscheduler.server.master.metrics.MasterServerMetrics;
import org.apache.dolphinscheduler.server.master.metrics.ProcessInstanceMetrics;
import org.apache.dolphinscheduler.server.master.registry.ServerNodeManager;
import org.apache.dolphinscheduler.server.master.runner.StateWheelExecuteThread;
import org.apache.dolphinscheduler.server.master.runner.WorkflowEventLooper;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.service.alert.ProcessAlertManager;
import org.apache.dolphinscheduler.service.expand.CuringParamsService;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.utils.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MasterSchedulerBootstrap
extends BaseDaemonThread
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MasterSchedulerBootstrap.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private ProcessInstanceDao processInstanceDao;
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private ProcessAlertManager processAlertManager;
    @Autowired
    private NettyExecutorManager nettyExecutorManager;
    private ThreadPoolExecutor masterPrepareExecService;
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;
    @Autowired
    private StateWheelExecuteThread stateWheelExecuteThread;
    @Autowired
    private CuringParamsService curingGlobalParamsService;
    @Autowired
    private WorkflowEventQueue workflowEventQueue;
    @Autowired
    private WorkflowEventLooper workflowEventLooper;
    @Autowired
    private ServerNodeManager serverNodeManager;
    private String masterAddress;

    protected MasterSchedulerBootstrap() {
        super("MasterCommandLoopThread");
    }

    public void init() {
        this.masterPrepareExecService = (ThreadPoolExecutor)ThreadUtils.newDaemonFixedThreadExecutor((String)"MasterPreExecThread", (int)this.masterConfig.getPreExecThreads());
        this.masterAddress = NetUtils.getAddr((int)this.masterConfig.getListenPort());
    }

    public synchronized void start() {
        logger.info("Master schedule bootstrap starting..");
        super.start();
        this.workflowEventLooper.start();
        logger.info("Master schedule bootstrap started...");
    }

    @Override
    public void close() {
        logger.info("Master schedule bootstrap stopping...");
        logger.info("Master schedule bootstrap stopped...");
    }

    public void run() {
        while (!ServerLifeCycleManager.isStopped()) {
            try {
                boolean isOverload;
                if (!ServerLifeCycleManager.isRunning()) {
                    logger.warn("The current server {} is not at running status, cannot consumes commands.", (Object)this.masterAddress);
                    Thread.sleep(1000L);
                }
                if (isOverload = OSUtils.isOverload((double)this.masterConfig.getMaxCpuLoadAvg(), (double)this.masterConfig.getReservedMemory()).booleanValue()) {
                    logger.warn("The current server {} is overload, cannot consumes commands.", (Object)this.masterAddress);
                    MasterServerMetrics.incMasterOverload();
                    Thread.sleep(1000L);
                    continue;
                }
                List<Command> commands = this.findCommands();
                if (CollectionUtils.isEmpty(commands)) {
                    Thread.sleep(1000L);
                    continue;
                }
                List<ProcessInstance> processInstances = this.command2ProcessInstance(commands);
                if (CollectionUtils.isEmpty(processInstances)) {
                    Thread.sleep(1000L);
                    continue;
                }
                MasterServerMetrics.incMasterConsumeCommand(commands.size());
                processInstances.forEach(processInstance -> {
                    try {
                        LoggerUtils.setWorkflowInstanceIdMDC((int)processInstance.getId());
                        if (this.processInstanceExecCacheManager.contains(processInstance.getId())) {
                            logger.error("The workflow instance is already been cached, this case shouldn't be happened");
                        }
                        WorkflowExecuteRunnable workflowRunnable = new WorkflowExecuteRunnable((ProcessInstance)processInstance, this.processService, this.processInstanceDao, this.nettyExecutorManager, this.processAlertManager, this.masterConfig, this.stateWheelExecuteThread, this.curingGlobalParamsService);
                        this.processInstanceExecCacheManager.cache(processInstance.getId(), workflowRunnable);
                        this.workflowEventQueue.addEvent(new WorkflowEvent(WorkflowEventType.START_WORKFLOW, processInstance.getId()));
                    }
                    finally {
                        LoggerUtils.removeWorkflowInstanceIdMDC();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                logger.warn("Master schedule bootstrap interrupted, close the loop", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                logger.error("Master schedule workflow error", (Throwable)e);
                ThreadUtils.sleep((long)1000L);
            }
        }
    }

    private List<ProcessInstance> command2ProcessInstance(List<Command> commands) throws InterruptedException {
        long commandTransformStartTime = System.currentTimeMillis();
        logger.info("Master schedule bootstrap transforming command to ProcessInstance, commandSize: {}", (Object)commands.size());
        List<ProcessInstance> processInstances = Collections.synchronizedList(new ArrayList(commands.size()));
        CountDownLatch latch = new CountDownLatch(commands.size());
        for (Command command : commands) {
            this.masterPrepareExecService.execute(() -> {
                try {
                    SlotCheckState slotCheckState = this.slotCheck(command);
                    if (slotCheckState.equals((Object)SlotCheckState.CHANGE) || slotCheckState.equals((Object)SlotCheckState.INJECT)) {
                        logger.info("Master handle command {} skip, slot check state: {}", (Object)command.getId(), (Object)slotCheckState);
                        return;
                    }
                    ProcessInstance processInstance = this.processService.handleCommand(this.masterAddress, command);
                    if (processInstance != null) {
                        processInstances.add(processInstance);
                        logger.info("Master handle command {} end, create process instance {}", (Object)command.getId(), (Object)processInstance.getId());
                    }
                }
                catch (Exception e) {
                    logger.error("Master handle command {} error ", (Object)command.getId(), (Object)e);
                    this.processService.moveToErrorCommand(command, e.toString());
                }
                finally {
                    latch.countDown();
                }
            });
        }
        latch.await();
        logger.info("Master schedule bootstrap transformed command to ProcessInstance, commandSize: {}, processInstanceSize: {}", (Object)commands.size(), (Object)processInstances.size());
        ProcessInstanceMetrics.recordProcessInstanceGenerateTime(System.currentTimeMillis() - commandTransformStartTime);
        return processInstances;
    }

    private List<Command> findCommands() throws MasterException {
        try {
            long scheduleStartTime = System.currentTimeMillis();
            int thisMasterSlot = this.serverNodeManager.getSlot();
            int masterCount = this.serverNodeManager.getMasterSize();
            if (masterCount <= 0) {
                logger.warn("Master count: {} is invalid, the current slot: {}", (Object)masterCount, (Object)thisMasterSlot);
                return Collections.emptyList();
            }
            int pageNumber = 0;
            int pageSize = this.masterConfig.getFetchCommandNum();
            List result = this.processService.findCommandPageBySlot(pageSize, pageNumber, masterCount, thisMasterSlot);
            if (CollectionUtils.isNotEmpty((Collection)result)) {
                logger.info("Master schedule bootstrap loop command success, command size: {}, current slot: {}, total slot size: {}", new Object[]{result.size(), thisMasterSlot, masterCount});
            }
            ProcessInstanceMetrics.recordCommandQueryTime(System.currentTimeMillis() - scheduleStartTime);
            return result;
        }
        catch (Exception ex) {
            throw new MasterException("Master loop command from database error", ex);
        }
    }

    private SlotCheckState slotCheck(Command command) {
        int slot = this.serverNodeManager.getSlot();
        int masterSize = this.serverNodeManager.getMasterSize();
        SlotCheckState state = masterSize <= 0 ? SlotCheckState.CHANGE : (command.getId() % masterSize == slot ? SlotCheckState.PASS : SlotCheckState.INJECT);
        return state;
    }
}

