/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.metrics;

import com.google.common.collect.ImmutableSet;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;

public final class ProcessInstanceMetrics {
    private static final Map<String, Counter> processInstanceCounters = new HashMap<String, Counter>();
    private static final Set<String> processInstanceStates = ImmutableSet.of((Object)"submit", (Object)"timeout", (Object)"finish", (Object)"failover", (Object)"success", (Object)"fail", (Object[])new String[]{"stop"});
    private static final Timer commandQueryTimer;
    private static final Timer processInstanceGenerateTimer;

    public static void recordCommandQueryTime(long milliseconds) {
        commandQueryTimer.record(milliseconds, TimeUnit.MILLISECONDS);
    }

    public static void recordProcessInstanceGenerateTime(long milliseconds) {
        processInstanceGenerateTimer.record(milliseconds, TimeUnit.MILLISECONDS);
    }

    public static synchronized void registerProcessInstanceRunningGauge(Supplier<Number> function) {
        Gauge.builder((String)"ds.workflow.instance.running", function).description("The current running process instance count").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static synchronized void registerProcessInstanceResubmitGauge(Supplier<Number> function) {
        Gauge.builder((String)"ds.workflow.instance.resubmit", function).description("The current process instance need to resubmit count").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static void incProcessInstanceByState(String state) {
        processInstanceCounters.get(state).increment();
    }

    @Generated
    private ProcessInstanceMetrics() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        for (String state : processInstanceStates) {
            processInstanceCounters.put(state, Counter.builder((String)"ds.workflow.instance.count").tag("state", state).description(String.format("Process instance %s total count", state)).register((MeterRegistry)Metrics.globalRegistry));
        }
        commandQueryTimer = Timer.builder((String)"ds.workflow.command.query.duration").description("Command query duration").register((MeterRegistry)Metrics.globalRegistry);
        processInstanceGenerateTimer = Timer.builder((String)"ds.workflow.instance.generate.duration").description("Process instance generated duration").register((MeterRegistry)Metrics.globalRegistry);
    }
}

