/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.WorkflowStateEventChangeCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.TaskStateEvent;
import org.apache.dolphinscheduler.server.master.event.WorkflowStateEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.StateEventResponseService;
import org.apache.dolphinscheduler.service.utils.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StateEventProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(StateEventProcessor.class);
    @Autowired
    private StateEventResponseService stateEventResponseService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.STATE_EVENT_REQUEST == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type: %s", command.getType()));
        WorkflowStateEventChangeCommand workflowStateEventChangeCommand = (WorkflowStateEventChangeCommand)JSONUtils.parseObject((byte[])command.getBody(), WorkflowStateEventChangeCommand.class);
        StateEvent stateEvent = workflowStateEventChangeCommand.getDestTaskInstanceId() == 0 ? this.createWorkflowStateEvent(workflowStateEventChangeCommand) : this.createTaskStateEvent(workflowStateEventChangeCommand);
        try {
            LoggerUtils.setWorkflowAndTaskInstanceIDMDC((Integer)stateEvent.getProcessInstanceId(), (Integer)stateEvent.getTaskInstanceId());
            this.logger.info("Received state change command, event: {}", (Object)stateEvent);
            this.stateEventResponseService.addStateChangeEvent(stateEvent);
        }
        finally {
            LoggerUtils.removeWorkflowAndTaskInstanceIdMDC();
        }
    }

    private TaskStateEvent createTaskStateEvent(WorkflowStateEventChangeCommand workflowStateEventChangeCommand) {
        return TaskStateEvent.builder().processInstanceId(workflowStateEventChangeCommand.getDestProcessInstanceId()).taskInstanceId(workflowStateEventChangeCommand.getDestTaskInstanceId()).type(StateEventType.TASK_STATE_CHANGE).key(workflowStateEventChangeCommand.getKey()).build();
    }

    private WorkflowStateEvent createWorkflowStateEvent(WorkflowStateEventChangeCommand workflowStateEventChangeCommand) {
        WorkflowExecutionStatus workflowExecutionStatus = workflowStateEventChangeCommand.getSourceStatus();
        if (workflowStateEventChangeCommand.getSourceProcessInstanceId() != workflowStateEventChangeCommand.getDestProcessInstanceId()) {
            workflowExecutionStatus = WorkflowExecutionStatus.RUNNING_EXECUTION;
        }
        return WorkflowStateEvent.builder().processInstanceId(workflowStateEventChangeCommand.getDestProcessInstanceId()).type(StateEventType.PROCESS_STATE_CHANGE).status(workflowExecutionStatus).key(workflowStateEventChangeCommand.getKey()).build();
    }
}

