/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependentRelation;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentItem;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentTaskModel;
import org.apache.dolphinscheduler.plugin.task.api.parameters.DependentParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.DependentUtils;
import org.apache.dolphinscheduler.server.master.runner.task.BaseTaskProcessor;
import org.apache.dolphinscheduler.server.master.runner.task.ITaskProcessor;
import org.apache.dolphinscheduler.service.utils.LogUtils;

@AutoService(value={ITaskProcessor.class})
public class ConditionTaskProcessor
extends BaseTaskProcessor {
    private DependentParameters dependentParameters;
    private DependResult conditionResult = DependResult.WAITING;
    private Map<Long, TaskExecutionStatus> completeTaskList = new ConcurrentHashMap<Long, TaskExecutionStatus>();

    @Override
    public boolean submitTask() {
        this.taskInstance = this.processService.submitTaskWithRetry(this.processInstance, this.taskInstance, this.maxRetryTimes, this.commitInterval);
        if (this.taskInstance == null) {
            return false;
        }
        this.setTaskExecutionLogger();
        this.logger.info("condition task submit success");
        return true;
    }

    @Override
    public boolean runTask() {
        this.initTaskParameters();
        this.logger.info("condition task start");
        if (this.conditionResult.equals((Object)DependResult.WAITING)) {
            this.setConditionResult();
            this.endTask();
        } else {
            this.endTask();
        }
        this.logger.info("condition task finished");
        return true;
    }

    @Override
    protected boolean resubmitTask() {
        return true;
    }

    @Override
    protected boolean dispatchTask() {
        return true;
    }

    @Override
    protected boolean pauseTask() {
        this.taskInstance.setState(TaskExecutionStatus.PAUSE);
        this.taskInstance.setEndTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
        return true;
    }

    @Override
    protected boolean taskTimeout() {
        TaskTimeoutStrategy taskTimeoutStrategy = this.taskInstance.getTaskDefine().getTimeoutNotifyStrategy();
        if (taskTimeoutStrategy == TaskTimeoutStrategy.WARN) {
            return true;
        }
        this.logger.info("condition task {} timeout, strategy {} ", (Object)this.taskInstance.getId(), (Object)taskTimeoutStrategy.getDescp());
        this.conditionResult = DependResult.FAILED;
        this.endTask();
        return true;
    }

    @Override
    protected boolean killTask() {
        this.taskInstance.setState(TaskExecutionStatus.KILL);
        this.taskInstance.setEndTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
        return true;
    }

    @Override
    public String getType() {
        return "CONDITIONS";
    }

    private void initTaskParameters() {
        this.taskInstance.setLogPath(LogUtils.getTaskLogPath((Date)this.taskInstance.getFirstSubmitTime(), (Long)this.processInstance.getProcessDefinitionCode(), (int)this.processInstance.getProcessDefinitionVersion(), (int)this.taskInstance.getProcessInstanceId(), (int)this.taskInstance.getId()));
        this.taskInstance.setHost(NetUtils.getAddr((int)this.masterConfig.getListenPort()));
        this.taskInstance.setState(TaskExecutionStatus.RUNNING_EXECUTION);
        this.taskInstance.setStartTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
        this.dependentParameters = this.taskInstance.getDependency();
    }

    private void setConditionResult() {
        List taskInstances = this.processService.findValidTaskListByProcessId(Integer.valueOf(this.taskInstance.getProcessInstanceId()));
        for (TaskInstance task : taskInstances) {
            this.completeTaskList.putIfAbsent(task.getTaskCode(), task.getState());
        }
        ArrayList<DependResult> modelResultList = new ArrayList<DependResult>();
        for (DependentTaskModel dependentTaskModel : this.dependentParameters.getDependTaskList()) {
            ArrayList<DependResult> itemDependResult = new ArrayList<DependResult>();
            for (DependentItem item : dependentTaskModel.getDependItemList()) {
                itemDependResult.add(this.getDependResultForItem(item));
            }
            DependResult modelResult = DependentUtils.getDependResultForRelation((DependentRelation)dependentTaskModel.getRelation(), itemDependResult);
            modelResultList.add(modelResult);
        }
        this.conditionResult = DependentUtils.getDependResultForRelation((DependentRelation)this.dependentParameters.getRelation(), modelResultList);
        this.logger.info("the conditions task depend result : {}", (Object)this.conditionResult);
    }

    private DependResult getDependResultForItem(DependentItem item) {
        DependResult dependResult = DependResult.SUCCESS;
        if (!this.completeTaskList.containsKey(item.getDepTaskCode())) {
            this.logger.info("depend item: {} have not completed yet.", (Object)item.getDepTaskCode());
            dependResult = DependResult.FAILED;
            return dependResult;
        }
        TaskExecutionStatus executionStatus = this.completeTaskList.get(item.getDepTaskCode());
        if (executionStatus != item.getStatus()) {
            this.logger.info("depend item : {} expect status: {}, actual status: {}", new Object[]{item.getDepTaskCode(), item.getStatus(), executionStatus});
            dependResult = DependResult.FAILED;
        }
        this.logger.info("dependent item complete, dependentTaskCode: {}, dependResult: {}", (Object)item.getDepTaskCode(), (Object)dependResult);
        return dependResult;
    }

    private void endTask() {
        TaskExecutionStatus status = this.conditionResult == DependResult.SUCCESS ? TaskExecutionStatus.SUCCESS : TaskExecutionStatus.FAILURE;
        this.taskInstance.setState(status);
        this.taskInstance.setEndTime(new Date());
        this.processService.updateTaskInstance(this.taskInstance);
    }
}

