/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.task;

import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.model.BaseHeartBeatTask;
import org.apache.dolphinscheduler.common.model.MasterHeartBeat;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.service.registry.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterHeartBeatTask
extends BaseHeartBeatTask<MasterHeartBeat> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterHeartBeatTask.class);
    private final MasterConfig masterConfig;
    private final RegistryClient registryClient;
    private final String heartBeatPath;
    private final int processId;

    public MasterHeartBeatTask(@NonNull MasterConfig masterConfig, @NonNull RegistryClient registryClient) {
        super("MasterHeartBeatTask", masterConfig.getHeartbeatInterval().toMillis());
        if (masterConfig == null) {
            throw new NullPointerException("masterConfig is marked non-null but is null");
        }
        if (registryClient == null) {
            throw new NullPointerException("registryClient is marked non-null but is null");
        }
        this.masterConfig = masterConfig;
        this.registryClient = registryClient;
        this.heartBeatPath = masterConfig.getMasterRegistryPath();
        this.processId = OSUtils.getProcessID();
    }

    public MasterHeartBeat getHeartBeat() {
        return MasterHeartBeat.builder().startupTime(ServerLifeCycleManager.getServerStartupTime()).reportTime(System.currentTimeMillis()).cpuUsage(OSUtils.cpuUsage()).loadAverage(OSUtils.loadAverage()).availablePhysicalMemorySize(OSUtils.availablePhysicalMemorySize()).maxCpuloadAvg(this.masterConfig.getMaxCpuLoadAvg()).reservedMemory(this.masterConfig.getReservedMemory()).memoryUsage(OSUtils.memoryUsage()).diskAvailable(OSUtils.diskAvailable()).processId(this.processId).build();
    }

    public void writeHeartBeat(MasterHeartBeat masterHeartBeat) {
        String masterHeartBeatJson = JSONUtils.toJsonString((Object)masterHeartBeat);
        this.registryClient.persistEphemeral(this.heartBeatPath, masterHeartBeatJson);
        log.info("Success write master heartBeatInfo into registry, masterRegistryPath: {}, heartBeatInfo: {}", (Object)this.heartBeatPath, (Object)masterHeartBeatJson);
    }
}

