/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.meter.metrics;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.MeterRegistry;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.meter.metrics.MetricsProvider;
import org.apache.dolphinscheduler.meter.metrics.SystemMetrics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultMetricsProvider
implements MetricsProvider {
    @Autowired
    private MeterRegistry meterRegistry;
    private SystemMetrics systemMetrics;
    private long lastRefreshTime = 0L;
    private static final long SYSTEM_METRICS_REFRESH_INTERVAL = 1000L;

    @Override
    public SystemMetrics getSystemMetrics() {
        if (System.currentTimeMillis() - this.lastRefreshTime < 1000L) {
            return this.systemMetrics;
        }
        double systemCpuUsage = this.meterRegistry.get("system.cpu.usage").gauge().value();
        double processCpuUsage = this.meterRegistry.get("process.cpu.usage").gauge().value();
        double jvmMemoryUsed = ((Measurement)this.meterRegistry.get("jvm.memory.used").meter().measure().iterator().next()).getValue();
        double jvmMemoryMax = ((Measurement)this.meterRegistry.get("jvm.memory.max").meter().measure().iterator().next()).getValue();
        long totalSystemMemory = OSUtils.getTotalSystemMemory();
        long systemMemoryAvailable = OSUtils.getSystemAvailableMemoryUsed();
        this.systemMetrics = SystemMetrics.builder().systemCpuUsagePercentage(systemCpuUsage).processCpuUsagePercentage(processCpuUsage).totalCpuUsedPercentage(systemCpuUsage + processCpuUsage).jvmMemoryUsed(jvmMemoryUsed).jvmMemoryMax(jvmMemoryMax).jvmMemoryUsedPercentage(jvmMemoryUsed / jvmMemoryMax).systemMemoryUsed(totalSystemMemory - systemMemoryAvailable).systemMemoryMax(totalSystemMemory).systemMemoryUsedPercentage((double)(totalSystemMemory - systemMemoryAvailable) / (double)totalSystemMemory).build();
        this.lastRefreshTime = System.currentTimeMillis();
        return this.systemMetrics;
    }
}

