/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.registry.api;

public class Event {
    private String key;
    private String path;
    private String data;
    private Type type;

    public Event(String key, String path, String data, Type type) {
        this.key = key;
        this.path = path;
        this.data = data;
        this.type = type;
    }

    public Event() {
    }

    public static EventBuilder builder() {
        return new EventBuilder();
    }

    public String key() {
        return this.key;
    }

    public String path() {
        return this.path;
    }

    public String data() {
        return this.data;
    }

    public Type type() {
        return this.type;
    }

    public Event key(String key) {
        this.key = key;
        return this;
    }

    public Event path(String path) {
        this.path = path;
        return this;
    }

    public Event data(String data) {
        this.data = data;
        return this;
    }

    public Event type(Type type) {
        this.type = type;
        return this;
    }

    public String toString() {
        return "Event(key=" + this.key() + ", path=" + this.path() + ", data=" + this.data() + ", type=" + (Object)((Object)this.type()) + ")";
    }

    public static class EventBuilder {
        private String key;
        private String path;
        private String data;
        private Type type;

        EventBuilder() {
        }

        public EventBuilder key(String key) {
            this.key = key;
            return this;
        }

        public EventBuilder path(String path) {
            this.path = path;
            return this;
        }

        public EventBuilder data(String data) {
            this.data = data;
            return this;
        }

        public EventBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public Event build() {
            return new Event(this.key, this.path, this.data, this.type);
        }

        public String toString() {
            return "Event.EventBuilder(key=" + this.key + ", path=" + this.path + ", data=" + this.data + ", type=" + (Object)((Object)this.type) + ")";
        }
    }

    public static enum Type {
        ADD,
        REMOVE,
        UPDATE;

    }
}

