/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.etcd;

import com.google.common.base.Splitter;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.ClientBuilder;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.Lock;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.options.DeleteOption;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.options.WatchOption;
import io.etcd.jetcd.support.Observers;
import io.etcd.jetcd.watch.WatchEvent;
import io.grpc.netty.GrpcSslContexts;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.net.ssl.SSLException;
import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.plugin.registry.etcd.EtcdConnectionStateListener;
import org.apache.dolphinscheduler.plugin.registry.etcd.EtcdKeepAliveLeaseManager;
import org.apache.dolphinscheduler.plugin.registry.etcd.EtcdRegistryProperties;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.Event;
import org.apache.dolphinscheduler.registry.api.Registry;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.apache.dolphinscheduler.registry.api.SubscribeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConditionalOnProperty(prefix="registry", name={"type"}, havingValue="etcd")
public class EtcdRegistry
implements Registry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EtcdRegistry.class);
    private final Client client;
    private EtcdConnectionStateListener etcdConnectionStateListener;
    private EtcdKeepAliveLeaseManager etcdKeepAliveLeaseManager;
    public static final String FOLDER_SEPARATOR = "/";
    private static final ThreadLocal<Map<String, Long>> threadLocalLockMap = new ThreadLocal();
    private final Map<String, Watch.Watcher> watcherMap = new ConcurrentHashMap<String, Watch.Watcher>();
    private static final long TIME_TO_LIVE_SECONDS = 30L;

    public EtcdRegistry(EtcdRegistryProperties registryProperties) throws SSLException {
        ClientBuilder clientBuilder = Client.builder().endpoints((Collection)Util.toURIs((Collection)Splitter.on((String)",").trimResults().splitToList((CharSequence)registryProperties.getEndpoints()))).namespace(EtcdRegistry.byteSequence(registryProperties.getNamespace())).connectTimeout(registryProperties.getConnectionTimeout()).retryChronoUnit(ChronoUnit.MILLIS).retryDelay(registryProperties.getRetryDelay().toMillis()).retryMaxDelay(registryProperties.getRetryMaxDelay().toMillis()).retryMaxDuration(registryProperties.getRetryMaxDuration());
        if (StringUtils.hasLength((String)registryProperties.getUser()) && StringUtils.hasLength((String)registryProperties.getPassword())) {
            clientBuilder.user(EtcdRegistry.byteSequence(registryProperties.getUser()));
            clientBuilder.password(EtcdRegistry.byteSequence(registryProperties.getPassword()));
        }
        if (StringUtils.hasLength((String)registryProperties.getLoadBalancerPolicy())) {
            clientBuilder.loadBalancerPolicy(registryProperties.getLoadBalancerPolicy());
        }
        if (StringUtils.hasLength((String)registryProperties.getAuthority())) {
            clientBuilder.authority(registryProperties.getAuthority());
        }
        if (StringUtils.hasLength((String)registryProperties.getCertFile()) && StringUtils.hasLength((String)registryProperties.getKeyCertChainFile()) && StringUtils.hasLength((String)registryProperties.getKeyFile())) {
            String userDir = System.getProperty("user.dir") + FOLDER_SEPARATOR;
            File certFile = new File(userDir + registryProperties.getCertFile());
            File keyCertChainFile = new File(userDir + registryProperties.getKeyCertChainFile());
            File keyFile = new File(userDir + registryProperties.getKeyFile());
            SslContext context = GrpcSslContexts.forClient().trustManager(certFile).keyManager(keyCertChainFile, keyFile).build();
            clientBuilder.sslContext(context);
        }
        this.client = clientBuilder.build();
        log.info("Started Etcd Registry...");
        this.etcdConnectionStateListener = new EtcdConnectionStateListener(this.client);
        this.etcdKeepAliveLeaseManager = new EtcdKeepAliveLeaseManager(this.client);
    }

    @PostConstruct
    public void start() {
        log.info("Starting Etcd ConnectionListener...");
        this.etcdConnectionStateListener.start();
        log.info("Started Etcd ConnectionListener...");
    }

    public void connectUntilTimeout(@NonNull Duration timeout) throws RegistryException {
        if (timeout == null) {
            throw new NullPointerException("timeout is marked non-null but is null");
        }
    }

    public boolean subscribe(String path, SubscribeListener listener) {
        try {
            ByteSequence watchKey = EtcdRegistry.byteSequence(path);
            WatchOption watchOption = WatchOption.newBuilder().withPrevKV(true).isPrefix(true).build();
            this.watcherMap.computeIfAbsent(path, $ -> this.client.getWatchClient().watch(watchKey, watchOption, watchResponse -> {
                for (WatchEvent event : watchResponse.getEvents()) {
                    listener.notify((Event)new EventAdaptor(event, path));
                }
            }));
        }
        catch (Exception e) {
            throw new RegistryException("Failed to subscribe listener for key: " + path, (Throwable)e);
        }
        return true;
    }

    public void unsubscribe(String path) {
        try {
            this.watcherMap.get(path).close();
            this.watcherMap.remove(path);
        }
        catch (Exception e) {
            throw new RegistryException("Failed to unsubscribe listener for key: " + path, (Throwable)e);
        }
    }

    public void addConnectionStateListener(ConnectionListener listener) {
        this.etcdConnectionStateListener.addConnectionListener(listener);
    }

    public String get(String key) {
        try {
            List keyValues = ((GetResponse)this.client.getKVClient().get(EtcdRegistry.byteSequence(key)).get()).getKvs();
            return ((KeyValue)keyValues.iterator().next()).getValue().toString(StandardCharsets.UTF_8);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RegistryException("etcd get data error", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RegistryException("etcd get data error, key = " + key, (Throwable)e);
        }
    }

    public void put(String key, String value, boolean deleteOnDisconnect) {
        try {
            if (deleteOnDisconnect) {
                long leaseId = this.etcdKeepAliveLeaseManager.getOrCreateKeepAliveLease(key, 30L);
                PutOption putOption = PutOption.newBuilder().withLeaseId(leaseId).build();
                this.client.getKVClient().put(EtcdRegistry.byteSequence(key), EtcdRegistry.byteSequence(value), putOption).get();
            } else {
                this.client.getKVClient().put(EtcdRegistry.byteSequence(key), EtcdRegistry.byteSequence(value)).get();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RegistryException("Failed to put registry key: " + key, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RegistryException("Failed to put registry key: " + key, (Throwable)e);
        }
    }

    public void delete(String key) {
        try {
            DeleteOption deleteOption = DeleteOption.newBuilder().isPrefix(true).build();
            this.client.getKVClient().delete(EtcdRegistry.byteSequence(key), deleteOption).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RegistryException("Failed to delete registry key: " + key, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RegistryException("Failed to delete registry key: " + key, (Throwable)e);
        }
    }

    public Collection<String> children(String key) {
        String prefix = key.endsWith(FOLDER_SEPARATOR) ? key : key + FOLDER_SEPARATOR;
        GetOption getOption = GetOption.newBuilder().isPrefix(true).withSortField(GetOption.SortTarget.KEY).withSortOrder(GetOption.SortOrder.ASCEND).build();
        try {
            List keyValues = ((GetResponse)this.client.getKVClient().get(EtcdRegistry.byteSequence(prefix), getOption).get()).getKvs();
            return keyValues.stream().map(e -> this.getSubNodeKeyName(prefix, e.getKey().toString(StandardCharsets.UTF_8))).distinct().collect(Collectors.toList());
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            throw new RegistryException("etcd get children error", (Throwable)e2);
        }
        catch (ExecutionException e3) {
            throw new RegistryException("etcd get children error, key: " + key, (Throwable)e3);
        }
    }

    private String getSubNodeKeyName(String prefix, String fullPath) {
        String pathWithoutPrefix = fullPath.substring(prefix.length());
        return pathWithoutPrefix.contains(FOLDER_SEPARATOR) ? pathWithoutPrefix.substring(0, pathWithoutPrefix.indexOf(FOLDER_SEPARATOR)) : pathWithoutPrefix;
    }

    public boolean exists(String key) {
        GetOption getOption = GetOption.newBuilder().withCountOnly(true).build();
        try {
            if (((GetResponse)this.client.getKVClient().get(EtcdRegistry.byteSequence(key), getOption).get()).getCount() >= 1L) {
                return true;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RegistryException("etcd check key is existed error", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RegistryException("etcd check key is existed error, key: " + key, (Throwable)e);
        }
        return false;
    }

    public boolean acquireLock(String key) {
        Lock lockClient = this.client.getLockClient();
        Lease leaseClient = this.client.getLeaseClient();
        try {
            long leaseId = ((LeaseGrantResponse)leaseClient.grant(30L).get()).getID();
            this.client.getLeaseClient().keepAlive(leaseId, Observers.observer(response -> {}));
            lockClient.lock(EtcdRegistry.byteSequence(key), leaseId).get();
            if (null == threadLocalLockMap.get()) {
                threadLocalLockMap.set(new HashMap());
            }
            threadLocalLockMap.get().put(key, leaseId);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RegistryException("etcd get lock error", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RegistryException("etcd get lock error, lockKey: " + key, (Throwable)e);
        }
    }

    public boolean releaseLock(String key) {
        try {
            Long leaseId = threadLocalLockMap.get().get(key);
            this.client.getLeaseClient().revoke(leaseId.longValue());
            threadLocalLockMap.get().remove(key);
            if (threadLocalLockMap.get().isEmpty()) {
                threadLocalLockMap.remove();
            }
        }
        catch (Exception e) {
            throw new RegistryException("etcd release lock error, lockKey: " + key, (Throwable)e);
        }
        return true;
    }

    public void close() throws IOException {
        this.client.close();
    }

    private static ByteSequence byteSequence(String val) {
        return ByteSequence.from((String)val, (Charset)StandardCharsets.UTF_8);
    }

    static final class EventAdaptor
    extends Event {
        public EventAdaptor(WatchEvent event, String key) {
            this.key(key);
            switch (event.getEventType()) {
                case PUT: {
                    if (event.getPrevKV().getKey().isEmpty()) {
                        this.type(Event.Type.ADD);
                        break;
                    }
                    this.type(Event.Type.UPDATE);
                    break;
                }
                case DELETE: {
                    this.type(Event.Type.REMOVE);
                    break;
                }
            }
            KeyValue keyValue = event.getKeyValue();
            if (keyValue != null) {
                this.path(keyValue.getKey().toString(StandardCharsets.UTF_8));
                this.data(keyValue.getValue().toString(StandardCharsets.UTF_8));
            }
        }
    }
}

