/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.jdbc;

import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.plugin.registry.jdbc.JdbcRegistryConstant;
import org.apache.dolphinscheduler.plugin.registry.jdbc.JdbcRegistryProperties;
import org.apache.dolphinscheduler.plugin.registry.jdbc.mapper.JdbcRegistryDataMapper;
import org.apache.dolphinscheduler.plugin.registry.jdbc.mapper.JdbcRegistryLockMapper;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DataType;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.JdbcRegistryData;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.JdbcRegistryLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="registry", name={"type"}, havingValue="jdbc")
public class JdbcOperator {
    @Autowired
    private JdbcRegistryDataMapper jdbcRegistryDataMapper;
    @Autowired
    private JdbcRegistryLockMapper jdbcRegistryLockMapper;
    private final long expireTimeWindow;

    public JdbcOperator(JdbcRegistryProperties registryProperties) {
        this.expireTimeWindow = (long)registryProperties.getTermExpireTimes() * registryProperties.getTermRefreshInterval().toMillis();
    }

    public void healthCheck() {
        this.jdbcRegistryLockMapper.countAll();
    }

    public List<JdbcRegistryData> queryAllJdbcRegistryData() {
        return this.jdbcRegistryDataMapper.selectAll();
    }

    public Long insertOrUpdateEphemeralData(String key, String value) throws SQLException {
        JdbcRegistryData jdbcRegistryData = this.jdbcRegistryDataMapper.selectByKey(key);
        if (jdbcRegistryData != null) {
            long id = jdbcRegistryData.getId();
            if (this.jdbcRegistryDataMapper.updateDataAndTermById(id, value, System.currentTimeMillis()) <= 0) {
                throw new SQLException(String.format("update registry value failed, key: %s, value: %s", key, value));
            }
            return id;
        }
        jdbcRegistryData = JdbcRegistryData.builder().dataKey(key).dataValue(value).dataType(DataType.EPHEMERAL.getTypeValue()).lastTerm(System.currentTimeMillis()).build();
        this.jdbcRegistryDataMapper.insert(jdbcRegistryData);
        return jdbcRegistryData.getId();
    }

    public long insertOrUpdatePersistentData(String key, String value) throws SQLException {
        JdbcRegistryData jdbcRegistryData = this.jdbcRegistryDataMapper.selectByKey(key);
        if (jdbcRegistryData != null) {
            long id = jdbcRegistryData.getId();
            if (this.jdbcRegistryDataMapper.updateDataAndTermById(id, value, System.currentTimeMillis()) <= 0) {
                throw new SQLException(String.format("update registry value failed, key: %s, value: %s", key, value));
            }
            return id;
        }
        jdbcRegistryData = JdbcRegistryData.builder().dataKey(key).dataValue(value).dataType(DataType.PERSISTENT.getTypeValue()).lastTerm(System.currentTimeMillis()).build();
        this.jdbcRegistryDataMapper.insert(jdbcRegistryData);
        return jdbcRegistryData.getId();
    }

    public void deleteDataByKey(String key) {
        this.jdbcRegistryDataMapper.deleteByKey(key);
    }

    public void deleteDataById(long id) {
        this.jdbcRegistryDataMapper.deleteById(Long.valueOf(id));
    }

    public void clearExpireLock() {
        this.jdbcRegistryLockMapper.clearExpireLock(System.currentTimeMillis() - this.expireTimeWindow);
    }

    public void clearExpireEphemeralDate() {
        this.jdbcRegistryDataMapper.clearExpireEphemeralDate(System.currentTimeMillis() - this.expireTimeWindow, DataType.EPHEMERAL.getTypeValue());
    }

    public JdbcRegistryData getData(String key) throws SQLException {
        return this.jdbcRegistryDataMapper.selectByKey(key);
    }

    public List<String> getChildren(String key) throws SQLException {
        return this.jdbcRegistryDataMapper.fuzzyQueryByKey(key).stream().map(JdbcRegistryData::getDataKey).filter(fullPath -> fullPath.length() > key.length()).map(fullPath -> StringUtils.substringBefore((String)fullPath.substring(key.length() + 1), (String)"/")).collect(Collectors.toList());
    }

    public boolean existKey(String key) throws SQLException {
        JdbcRegistryData jdbcRegistryData = this.jdbcRegistryDataMapper.selectByKey(key);
        return jdbcRegistryData != null;
    }

    public JdbcRegistryLock tryToAcquireLock(String key) throws SQLException {
        JdbcRegistryLock jdbcRegistryLock = JdbcRegistryLock.builder().lockKey(key).lockOwner(JdbcRegistryConstant.LOCK_OWNER).lastTerm(System.currentTimeMillis()).build();
        try {
            this.jdbcRegistryLockMapper.insert(jdbcRegistryLock);
            return jdbcRegistryLock;
        }
        catch (Exception e) {
            if (e instanceof SQLIntegrityConstraintViolationException) {
                return null;
            }
            throw e;
        }
    }

    public JdbcRegistryLock getLockById(long lockId) throws SQLException {
        return (JdbcRegistryLock)this.jdbcRegistryLockMapper.selectById(Long.valueOf(lockId));
    }

    public boolean releaseLock(long lockId) throws SQLException {
        return this.jdbcRegistryLockMapper.deleteById(Long.valueOf(lockId)) > 0;
    }

    public boolean updateEphemeralDataTerm(Collection<Long> ephemeralDateIds) throws SQLException {
        if (CollectionUtils.isEmpty(ephemeralDateIds)) {
            return true;
        }
        return this.jdbcRegistryDataMapper.updateTermByIds(ephemeralDateIds, System.currentTimeMillis()) > 0;
    }

    public boolean updateLockTerm(List<Long> lockIds) {
        if (CollectionUtils.isEmpty(lockIds)) {
            return true;
        }
        return this.jdbcRegistryLockMapper.updateTermByIds(lockIds, System.currentTimeMillis()) > 0;
    }
}

