/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.jdbc;

import java.sql.SQLException;
import java.time.Duration;
import java.util.Collection;
import javax.annotation.PostConstruct;
import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.plugin.registry.jdbc.JdbcOperator;
import org.apache.dolphinscheduler.plugin.registry.jdbc.JdbcRegistryProperties;
import org.apache.dolphinscheduler.plugin.registry.jdbc.task.EphemeralDateManager;
import org.apache.dolphinscheduler.plugin.registry.jdbc.task.RegistryLockManager;
import org.apache.dolphinscheduler.plugin.registry.jdbc.task.SubscribeDataManager;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.ConnectionState;
import org.apache.dolphinscheduler.registry.api.Registry;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.apache.dolphinscheduler.registry.api.SubscribeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="registry", name={"type"}, havingValue="jdbc")
public class JdbcRegistry
implements Registry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcRegistry.class);
    private final JdbcRegistryProperties jdbcRegistryProperties;
    private final EphemeralDateManager ephemeralDateManager;
    private final SubscribeDataManager subscribeDataManager;
    private final RegistryLockManager registryLockManager;
    private JdbcOperator jdbcOperator;

    public JdbcRegistry(JdbcRegistryProperties jdbcRegistryProperties, JdbcOperator jdbcOperator) {
        this.jdbcOperator = jdbcOperator;
        jdbcOperator.clearExpireLock();
        jdbcOperator.clearExpireEphemeralDate();
        this.jdbcRegistryProperties = jdbcRegistryProperties;
        this.ephemeralDateManager = new EphemeralDateManager(jdbcRegistryProperties, jdbcOperator);
        this.subscribeDataManager = new SubscribeDataManager(jdbcRegistryProperties, jdbcOperator);
        this.registryLockManager = new RegistryLockManager(jdbcRegistryProperties, jdbcOperator);
        log.info("Initialize Jdbc Registry...");
    }

    @PostConstruct
    public void start() {
        log.info("Starting Jdbc Registry...");
        this.ephemeralDateManager.start();
        this.subscribeDataManager.start();
        this.registryLockManager.start();
        log.info("Started Jdbc Registry...");
    }

    public void connectUntilTimeout(@NonNull Duration timeout) throws RegistryException {
        long endTimeMills;
        if (timeout == null) {
            throw new NullPointerException("timeout is marked non-null but is null");
        }
        long beginTimeMillis = System.currentTimeMillis();
        long l = endTimeMills = timeout.getSeconds() <= 0L ? Long.MAX_VALUE : beginTimeMillis + timeout.toMillis();
        while (true) {
            if (System.currentTimeMillis() > endTimeMills) {
                throw new RegistryException(String.format("Cannot connect to jdbc registry in %s s", timeout.getSeconds()));
            }
            if (this.ephemeralDateManager.getConnectionState() == ConnectionState.CONNECTED) {
                return;
            }
            try {
                Thread.sleep(this.jdbcRegistryProperties.getTermRefreshInterval().toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RegistryException("Cannot connect to jdbc registry due to interrupted exception", (Throwable)e);
            }
        }
    }

    public boolean subscribe(String path, SubscribeListener listener) {
        this.subscribeDataManager.addListener(path, listener);
        return true;
    }

    public void unsubscribe(String path) {
        this.subscribeDataManager.removeListener(path);
    }

    public void addConnectionStateListener(ConnectionListener listener) {
        this.ephemeralDateManager.addConnectionListener(listener);
    }

    public String get(String key) {
        return this.subscribeDataManager.getData(key);
    }

    public void put(String key, String value, boolean deleteOnDisconnect) {
        try {
            if (deleteOnDisconnect) {
                this.ephemeralDateManager.insertOrUpdateEphemeralData(key, value);
            } else {
                this.jdbcOperator.insertOrUpdatePersistentData(key, value);
            }
        }
        catch (Exception ex) {
            throw new RegistryException(String.format("put key:%s, value:%s error", key, value), (Throwable)ex);
        }
    }

    public void delete(String key) {
        try {
            this.jdbcOperator.deleteDataByKey(key);
        }
        catch (Exception e) {
            throw new RegistryException(String.format("Delete key: %s error", key), (Throwable)e);
        }
    }

    public Collection<String> children(String key) {
        try {
            return this.jdbcOperator.getChildren(key);
        }
        catch (SQLException e) {
            throw new RegistryException(String.format("Get key: %s children error", key), (Throwable)e);
        }
    }

    public boolean exists(String key) {
        try {
            return this.jdbcOperator.existKey(key);
        }
        catch (Exception e) {
            throw new RegistryException(String.format("Check key: %s exist error", key), (Throwable)e);
        }
    }

    public boolean acquireLock(String key) {
        try {
            this.registryLockManager.acquireLock(key);
            return true;
        }
        catch (RegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryException(String.format("Acquire lock: %s error", key), (Throwable)e);
        }
    }

    public boolean releaseLock(String key) {
        this.registryLockManager.releaseLock(key);
        return true;
    }

    public void close() {
        log.info("Closing Jdbc Registry...");
        try (EphemeralDateManager closed1 = this.ephemeralDateManager;
             SubscribeDataManager close2 = this.subscribeDataManager;){
            RegistryLockManager close3 = this.registryLockManager;
            Throwable throwable = null;
            if (close3 != null) {
                if (throwable != null) {
                    try {
                        close3.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    close3.close();
                }
            }
        }
        catch (Exception e) {
            log.error("Close Jdbc Registry error", (Throwable)e);
        }
        log.info("Closed Jdbc Registry...");
    }
}

