/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.jdbc.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import java.util.Collection;
import java.util.List;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.JdbcRegistryData;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface JdbcRegistryDataMapper
extends BaseMapper<JdbcRegistryData> {
    @Select(value={"select * from t_ds_jdbc_registry_data"})
    public List<JdbcRegistryData> selectAll();

    @Select(value={"select * from t_ds_jdbc_registry_data where data_key = #{key}"})
    public JdbcRegistryData selectByKey(@Param(value="key") String var1);

    @Select(value={"select * from t_ds_jdbc_registry_data where data_key like CONCAT (#{key}, '%')"})
    public List<JdbcRegistryData> fuzzyQueryByKey(@Param(value="key") String var1);

    @Update(value={"update t_ds_jdbc_registry_data set data_value = #{data}, last_term = #{term} where id = #{id}"})
    public int updateDataAndTermById(@Param(value="id") long var1, @Param(value="data") String var3, @Param(value="term") long var4);

    @Delete(value={"delete from t_ds_jdbc_registry_data where data_key = #{key}"})
    public void deleteByKey(@Param(value="key") String var1);

    @Delete(value={"delete from t_ds_jdbc_registry_data where last_term < #{term} and data_type = #{type}"})
    public void clearExpireEphemeralDate(@Param(value="term") long var1, @Param(value="type") int var3);

    @Update(value={"<script>", "update t_ds_jdbc_registry_data", "set last_term = #{term}", "where id IN ", "<foreach item='id' index='index' collection='ids' open='(' separator=',' close=')'>", "   #{id}", "</foreach>", "</script>"})
    public int updateTermByIds(@Param(value="ids") Collection<Long> var1, @Param(value="term") long var2);
}

