/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.jdbc.task;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.plugin.registry.jdbc.JdbcOperator;
import org.apache.dolphinscheduler.plugin.registry.jdbc.JdbcRegistryProperties;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.JdbcRegistryLock;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryLockManager
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegistryLockManager.class);
    private final JdbcOperator jdbcOperator;
    private final JdbcRegistryProperties registryProperties;
    private final Map<String, JdbcRegistryLock> lockHoldMap;
    private final ScheduledExecutorService lockTermUpdateThreadPool;

    public RegistryLockManager(JdbcRegistryProperties registryProperties, JdbcOperator jdbcOperator) {
        this.registryProperties = registryProperties;
        this.jdbcOperator = jdbcOperator;
        this.lockHoldMap = new ConcurrentHashMap<String, JdbcRegistryLock>();
        this.lockTermUpdateThreadPool = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("JdbcRegistryLockTermRefreshThread").setDaemon(true).build());
    }

    public void start() {
        this.lockTermUpdateThreadPool.scheduleWithFixedDelay(new LockTermRefreshTask(this.lockHoldMap, this.jdbcOperator), this.registryProperties.getTermRefreshInterval().toMillis(), this.registryProperties.getTermRefreshInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    public void acquireLock(String lockKey) throws RegistryException {
        this.lockHoldMap.computeIfAbsent(lockKey, key -> {
            JdbcRegistryLock jdbcRegistryLock;
            try {
                while ((jdbcRegistryLock = this.jdbcOperator.tryToAcquireLock(lockKey)) == null) {
                    log.debug("Acquire the lock {} failed try again", key);
                    ThreadUtils.sleep((long)1000L);
                }
            }
            catch (SQLException e) {
                throw new RegistryException("Acquire the lock error", (Throwable)e);
            }
            return jdbcRegistryLock;
        });
    }

    public void releaseLock(String lockKey) {
        JdbcRegistryLock jdbcRegistryLock = this.lockHoldMap.get(lockKey);
        if (jdbcRegistryLock != null) {
            try {
                this.jdbcOperator.releaseLock(jdbcRegistryLock.getId());
                this.lockHoldMap.remove(lockKey);
            }
            catch (SQLException e) {
                throw new RegistryException(String.format("Release lock: %s error", lockKey), (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        this.lockTermUpdateThreadPool.shutdownNow();
        for (Map.Entry<String, JdbcRegistryLock> lockEntry : this.lockHoldMap.entrySet()) {
            this.releaseLock(lockEntry.getKey());
        }
    }

    static class LockTermRefreshTask
    implements Runnable {
        private final Map<String, JdbcRegistryLock> lockHoldMap;
        private final JdbcOperator jdbcOperator;

        @Override
        public void run() {
            try {
                if (this.lockHoldMap.isEmpty()) {
                    return;
                }
                List<Long> lockIds = this.lockHoldMap.values().stream().map(JdbcRegistryLock::getId).collect(Collectors.toList());
                if (!this.jdbcOperator.updateLockTerm(lockIds)) {
                    log.warn("Update the lock: {} term failed.", lockIds);
                }
                this.jdbcOperator.clearExpireLock();
            }
            catch (Exception e) {
                log.error("Update lock term error", (Throwable)e);
            }
        }

        @Generated
        private LockTermRefreshTask(Map<String, JdbcRegistryLock> lockHoldMap, JdbcOperator jdbcOperator) {
            this.lockHoldMap = lockHoldMap;
            this.jdbcOperator = jdbcOperator;
        }
    }
}

