/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dolphinscheduler.remote.codec.NettyDecoder;
import org.apache.dolphinscheduler.remote.codec.NettyEncoder;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.config.NettyServerConfig;
import org.apache.dolphinscheduler.remote.exceptions.RemoteException;
import org.apache.dolphinscheduler.remote.handler.NettyServerHandler;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.remote.utils.Constants;
import org.apache.dolphinscheduler.remote.utils.NettyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyRemotingServer {
    private final Logger logger = LoggerFactory.getLogger(NettyRemotingServer.class);
    private final ServerBootstrap serverBootstrap = new ServerBootstrap();
    private final ExecutorService defaultExecutor = Executors.newFixedThreadPool(Constants.CPUS);
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workGroup;
    private final NettyServerConfig serverConfig;
    private final NettyServerHandler serverHandler = new NettyServerHandler(this);
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private static final String NETTY_BIND_FAILURE_MSG = "NettyRemotingServer bind %s fail";

    public NettyRemotingServer(NettyServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        ThreadFactory bossThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("NettyServerBossThread_%s").build();
        ThreadFactory workerThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("NettyServerWorkerThread_%s").build();
        if (Epoll.isAvailable()) {
            this.bossGroup = new EpollEventLoopGroup(1, bossThreadFactory);
            this.workGroup = new EpollEventLoopGroup(serverConfig.getWorkerThread(), workerThreadFactory);
        } else {
            this.bossGroup = new NioEventLoopGroup(1, bossThreadFactory);
            this.workGroup = new NioEventLoopGroup(serverConfig.getWorkerThread(), workerThreadFactory);
        }
    }

    public void start() {
        if (this.isStarted.compareAndSet(false, true)) {
            ChannelFuture future;
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group(this.bossGroup, this.workGroup).channel(NettyUtils.getServerSocketChannelClass())).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)this.serverConfig.getSoBacklog())).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.serverConfig.isSoKeepalive()).childOption(ChannelOption.TCP_NODELAY, (Object)this.serverConfig.isTcpNoDelay()).childOption(ChannelOption.SO_SNDBUF, (Object)this.serverConfig.getSendBufferSize()).childOption(ChannelOption.SO_RCVBUF, (Object)this.serverConfig.getReceiveBufferSize()).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    NettyRemotingServer.this.initNettyChannel(ch);
                }
            });
            try {
                future = this.serverBootstrap.bind(this.serverConfig.getListenPort()).sync();
            }
            catch (Exception e) {
                this.logger.error("NettyRemotingServer bind fail {}, exit", (Object)e.getMessage(), (Object)e);
                throw new RemoteException(String.format(NETTY_BIND_FAILURE_MSG, this.serverConfig.getListenPort()));
            }
            if (future.isSuccess()) {
                this.logger.info("NettyRemotingServer bind success at port : {}", (Object)this.serverConfig.getListenPort());
            } else {
                if (future.cause() != null) {
                    throw new RemoteException(String.format(NETTY_BIND_FAILURE_MSG, this.serverConfig.getListenPort()), future.cause());
                }
                throw new RemoteException(String.format(NETTY_BIND_FAILURE_MSG, this.serverConfig.getListenPort()));
            }
        }
    }

    private void initNettyChannel(SocketChannel ch) {
        ch.pipeline().addLast("encoder", (ChannelHandler)new NettyEncoder()).addLast("decoder", (ChannelHandler)new NettyDecoder()).addLast("server-idle-handle", (ChannelHandler)new IdleStateHandler(0L, 0L, 181000L, TimeUnit.MILLISECONDS)).addLast("handler", (ChannelHandler)this.serverHandler);
    }

    public void registerProcessor(CommandType commandType, NettyRequestProcessor processor) {
        this.registerProcessor(commandType, processor, null);
    }

    public void registerProcessor(CommandType commandType, NettyRequestProcessor processor, ExecutorService executor) {
        this.serverHandler.registerProcessor(commandType, processor, executor);
    }

    public ExecutorService getDefaultExecutor() {
        return this.defaultExecutor;
    }

    public void close() {
        if (this.isStarted.compareAndSet(true, false)) {
            try {
                if (this.bossGroup != null) {
                    this.bossGroup.shutdownGracefully();
                }
                if (this.workGroup != null) {
                    this.workGroup.shutdownGracefully();
                }
                this.defaultExecutor.shutdown();
            }
            catch (Exception ex) {
                this.logger.error("netty server close exception", (Throwable)ex);
            }
            this.logger.info("netty server closed");
        }
    }
}

