/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.List;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandContext;
import org.apache.dolphinscheduler.remote.command.CommandHeader;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyDecoder
extends ReplayingDecoder<State> {
    private static final Logger logger = LoggerFactory.getLogger(NettyDecoder.class);
    private final CommandHeader commandHeader = new CommandHeader();

    public NettyDecoder() {
        super((Object)State.MAGIC);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case MAGIC: {
                this.checkMagic(in.readByte());
                this.checkpoint((Object)State.VERSION);
            }
            case VERSION: {
                this.checkVersion(in.readByte());
                this.checkpoint((Object)State.COMMAND);
            }
            case COMMAND: {
                this.commandHeader.setType(in.readByte());
                this.checkpoint((Object)State.OPAQUE);
            }
            case OPAQUE: {
                this.commandHeader.setOpaque(in.readLong());
                this.checkpoint((Object)State.CONTEXT_LENGTH);
            }
            case CONTEXT_LENGTH: {
                this.commandHeader.setContextLength(in.readInt());
                this.checkpoint((Object)State.CONTEXT);
            }
            case CONTEXT: {
                byte[] context = new byte[this.commandHeader.getContextLength()];
                in.readBytes(context);
                this.commandHeader.setContext(context);
                this.checkpoint((Object)State.BODY_LENGTH);
            }
            case BODY_LENGTH: {
                this.commandHeader.setBodyLength(in.readInt());
                this.checkpoint((Object)State.BODY);
            }
            case BODY: {
                byte[] body = new byte[this.commandHeader.getBodyLength()];
                in.readBytes(body);
                Command packet = new Command();
                packet.setType(this.commandType(this.commandHeader.getType()));
                packet.setOpaque(this.commandHeader.getOpaque());
                packet.setContext(CommandContext.valueOf(this.commandHeader.getContext()));
                packet.setBody(body);
                out.add(packet);
                this.checkpoint((Object)State.MAGIC);
                break;
            }
            default: {
                logger.warn("unknown decoder state {}", this.state());
            }
        }
    }

    private CommandType commandType(byte type) {
        for (CommandType ct : CommandType.values()) {
            if (ct.ordinal() != type) continue;
            return ct;
        }
        return null;
    }

    private void checkMagic(byte magic) {
        if (magic != -66) {
            throw new IllegalArgumentException("illegal packet [magic]" + magic);
        }
    }

    private void checkVersion(byte version) {
        if (version != 0) {
            throw new IllegalArgumentException("illegal protocol [version]" + version);
        }
    }

    static enum State {
        MAGIC,
        VERSION,
        COMMAND,
        OPAQUE,
        CONTEXT_LENGTH,
        CONTEXT,
        BODY_LENGTH,
        BODY;

    }
}

