/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.command;

import java.io.Serializable;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;

public class TaskEventChangeCommand
implements Serializable {
    private String key;
    private int processInstanceId;
    private int taskInstanceId;

    public TaskEventChangeCommand(int processInstanceId, int taskInstanceId) {
        this.key = String.format("%d-%d", processInstanceId, taskInstanceId);
        this.processInstanceId = processInstanceId;
        this.taskInstanceId = taskInstanceId;
    }

    public Command convert2Command(CommandType commandType) {
        Command command = new Command();
        command.setType(commandType);
        byte[] body = JSONUtils.toJsonByteArray((Object)this);
        command.setBody(body);
        return command;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public int getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Generated
    public int getTaskInstanceId() {
        return this.taskInstanceId;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setProcessInstanceId(int processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Generated
    public void setTaskInstanceId(int taskInstanceId) {
        this.taskInstanceId = taskInstanceId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskEventChangeCommand)) {
            return false;
        }
        TaskEventChangeCommand other = (TaskEventChangeCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProcessInstanceId() != other.getProcessInstanceId()) {
            return false;
        }
        if (this.getTaskInstanceId() != other.getTaskInstanceId()) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskEventChangeCommand;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getProcessInstanceId();
        result = result * 59 + this.getTaskInstanceId();
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskEventChangeCommand(key=" + this.getKey() + ", processInstanceId=" + this.getProcessInstanceId() + ", taskInstanceId=" + this.getTaskInstanceId() + ")";
    }

    @Generated
    public TaskEventChangeCommand() {
    }
}

