/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.command;

import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.BaseCommand;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;

public class TaskExecuteAckCommand
extends BaseCommand {
    private int taskInstanceId;
    private boolean success;

    public TaskExecuteAckCommand(boolean success, int taskInstanceId, String sourceServerAddress, String messageReceiverAddress, long messageSendTime) {
        super(sourceServerAddress, messageReceiverAddress, messageSendTime);
        this.success = success;
        this.taskInstanceId = taskInstanceId;
    }

    public Command convert2Command() {
        Command command = new Command();
        command.setType(CommandType.TASK_EXECUTE_RESULT_ACK);
        byte[] body = JSONUtils.toJsonByteArray((Object)this);
        command.setBody(body);
        return command;
    }

    @Generated
    public int getTaskInstanceId() {
        return this.taskInstanceId;
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    public void setTaskInstanceId(int taskInstanceId) {
        this.taskInstanceId = taskInstanceId;
    }

    @Generated
    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Generated
    public TaskExecuteAckCommand() {
    }

    @Override
    @Generated
    public String toString() {
        return "TaskExecuteAckCommand(super=" + super.toString() + ", taskInstanceId=" + this.getTaskInstanceId() + ", success=" + this.isSuccess() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskExecuteAckCommand)) {
            return false;
        }
        TaskExecuteAckCommand other = (TaskExecuteAckCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTaskInstanceId() != other.getTaskInstanceId()) {
            return false;
        }
        return this.isSuccess() == other.isSuccess();
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskExecuteAckCommand;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getTaskInstanceId();
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        return result;
    }
}

