/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.utils;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger increment = new AtomicInteger(1);
    private final String name;
    private final int count;

    public NamedThreadFactory(String name) {
        this(name, 0);
    }

    public NamedThreadFactory(String name, int count) {
        this.name = name;
        this.count = count;
    }

    @Override
    public Thread newThread(Runnable r) {
        String threadName = this.count > 0 ? String.format("%s_%d_%d", this.name, this.count, this.increment.getAndIncrement()) : String.format("%s_%d", this.name, this.increment.getAndIncrement());
        Thread t = new Thread(r, threadName);
        t.setDaemon(true);
        return t;
    }
}

