/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.rpc.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.apache.dolphinscheduler.rpc.protocol.MessageHeader;
import org.apache.dolphinscheduler.rpc.protocol.RpcProtocol;
import org.apache.dolphinscheduler.rpc.serializer.RpcSerializer;
import org.apache.dolphinscheduler.rpc.serializer.Serializer;

public class NettyEncoder
extends MessageToByteEncoder<RpcProtocol<Object>> {
    protected void encode(ChannelHandlerContext channelHandlerContext, RpcProtocol<Object> msg, ByteBuf byteBuf) throws Exception {
        MessageHeader msgHeader = msg.getMsgHeader();
        byteBuf.writeShort((int)msgHeader.getMagic());
        byteBuf.writeByte((int)msgHeader.getEventType());
        byteBuf.writeByte((int)msgHeader.getVersion());
        byteBuf.writeByte((int)msgHeader.getSerialization());
        byteBuf.writeLong(msgHeader.getRequestId());
        byte[] data = new byte[]{};
        int msgLength = msgHeader.getMsgLength();
        Serializer rpcSerializer = RpcSerializer.getSerializerByType(msgHeader.getSerialization());
        if (null != rpcSerializer) {
            data = rpcSerializer.serialize(msg.getBody());
            msgLength = data.length;
        }
        byteBuf.writeInt(msgLength);
        byteBuf.writeBytes(data);
    }
}

