/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.scheduler.quartz.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.quartz.JobKey;

public final class QuartzTaskUtils {
    public static final String QUARTZ_JOB_PREFIX = "job";
    public static final String QUARTZ_JOB_GROUP_PREFIX = "jobgroup";
    public static final String UNDERLINE = "_";
    public static final String PROJECT_ID = "projectId";
    public static final String SCHEDULE_ID = "scheduleId";
    public static final String SCHEDULE = "schedule";

    public static JobKey getJobKey(int schedulerId, int projectId) {
        String jobName = "job_" + schedulerId;
        String jobGroup = "jobgroup_" + projectId;
        return new JobKey(jobName, jobGroup);
    }

    public static Map<String, Object> buildDataMap(int projectId, Schedule schedule) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        dataMap.put(PROJECT_ID, projectId);
        dataMap.put(SCHEDULE_ID, schedule.getId());
        dataMap.put(SCHEDULE, JSONUtils.toJsonString((Object)schedule));
        return dataMap;
    }
}

