/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.queue;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.service.exceptions.TaskPriorityQueueException;
import org.apache.dolphinscheduler.service.queue.TaskPriorityQueue;

public class StandByTaskInstancePriorityQueue
implements TaskPriorityQueue<TaskInstance> {
    private static final Integer QUEUE_MAX_SIZE = 3000;
    private final PriorityQueue<TaskInstance> queue = new PriorityQueue<TaskInstance>(QUEUE_MAX_SIZE, new TaskInstancePriorityComparator());
    private final Set<String> taskInstanceIdentifySet = Collections.synchronizedSet(new HashSet());

    @Override
    public void put(TaskInstance taskInstance) {
        Preconditions.checkNotNull((Object)taskInstance);
        this.queue.add(taskInstance);
        this.taskInstanceIdentifySet.add(this.getTaskInstanceIdentify(taskInstance));
    }

    @Override
    public TaskInstance take() throws TaskPriorityQueueException {
        TaskInstance taskInstance = this.queue.poll();
        if (taskInstance != null) {
            this.taskInstanceIdentifySet.remove(this.getTaskInstanceIdentify(taskInstance));
        }
        return taskInstance;
    }

    @Override
    public TaskInstance poll(long timeout, TimeUnit unit) throws TaskPriorityQueueException {
        throw new TaskPriorityQueueException("This operation is not currently supported and suggest to use PriorityBlockingQueue if you want\uff01");
    }

    public TaskInstance peek() {
        return this.queue.peek();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    public void clear() {
        this.queue.clear();
        this.taskInstanceIdentifySet.clear();
    }

    public boolean contains(TaskInstance taskInstance) {
        Preconditions.checkNotNull((Object)taskInstance);
        return this.taskInstanceIdentifySet.contains(this.getTaskInstanceIdentify(taskInstance));
    }

    public boolean remove(TaskInstance taskInstance) {
        Preconditions.checkNotNull((Object)taskInstance);
        this.taskInstanceIdentifySet.remove(this.getTaskInstanceIdentify(taskInstance));
        return this.queue.remove(taskInstance);
    }

    public Iterator<TaskInstance> iterator() {
        return this.queue.iterator();
    }

    private String getTaskInstanceIdentify(TaskInstance taskInstance) {
        return String.join((CharSequence)String.valueOf(taskInstance.getProcessInstanceId()), String.valueOf(taskInstance.getTaskCode()), String.valueOf(taskInstance.getTaskDefinitionVersion()), "-");
    }

    private static class TaskInstancePriorityComparator
    implements Comparator<TaskInstance> {
        private TaskInstancePriorityComparator() {
        }

        @Override
        public int compare(TaskInstance o1, TaskInstance o2) {
            int taskPriorityInTaskGroup = -1 * Integer.compare(o1.getTaskGroupPriority(), o2.getTaskGroupPriority());
            int taskInstancePriorityInWorkflow = Long.compare(o1.getTaskInstancePriority().getCode(), o2.getTaskInstancePriority().getCode());
            if (o1.getTaskGroupId() == o2.getTaskGroupId() && taskPriorityInTaskGroup != 0) {
                return taskPriorityInTaskGroup;
            }
            return taskInstancePriorityInWorkflow;
        }
    }
}

