/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.skywalking.plugin;

import java.lang.reflect.Method;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.master.runner.MasterBaseTaskExecThread;
import org.apache.dolphinscheduler.skywalking.plugin.TaskContext;
import org.apache.dolphinscheduler.skywalking.plugin.Utils;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;

public class MasterBaseTaskExecThreadMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        TaskContext taskContext = (TaskContext)objInst.getSkyWalkingDynamicField();
        TaskInstance taskInstance = (TaskInstance)taskContext.getCache();
        String operationName = MasterBaseTaskExecThreadMethodInterceptor.getOperationNamePrefix(taskInstance) + taskInstance.getName();
        AbstractSpan span = ContextManager.createLocalSpan((String)operationName);
        span.setComponent((Component)Utils.DOLPHIN_SCHEDULER);
        Utils.TAG_PROCESS_DEFINITION_ID.set(span, String.valueOf(taskInstance.getProcessDefinitionId()));
        Utils.TAG_PROCESS_INSTANCE_ID.set(span, String.valueOf(taskInstance.getProcessInstanceId()));
        Utils.TAG_TASK_TYPE.set(span, taskInstance.getTaskType());
        Utils.TAG_TASK_INSTANCE_ID.set(span, String.valueOf(taskInstance.getId()));
        Utils.TAG_TASK_INSTANCE_NAME.set(span, taskInstance.getName());
        Utils.TAG_TASK_WORKER_GROUP.set(span, taskInstance.getWorkerGroup());
        Utils.TAG_EXECUTE_METHOD.set(span, Utils.getMethodName(method));
        ContextManager.continued((ContextSnapshot)taskContext.getContextSnapshot());
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        AbstractSpan span = ContextManager.activeSpan();
        MasterBaseTaskExecThread original = (MasterBaseTaskExecThread)objInst;
        TaskInstance taskInstance = original.getTaskInstance();
        ExecutionStatus executionStatus = taskInstance.getState();
        Utils.TAG_TASK_STATE.set(span, taskInstance.getState().getDescp());
        if (!ExecutionStatus.SUCCESS.equals((Object)executionStatus)) {
            span.errorOccurred();
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    private static String getOperationNamePrefix(TaskInstance taskInstance) {
        String prefix = "";
        prefix = taskInstance.isSubProcess() ? "master/subprocess_task/" : (taskInstance.isDependTask() ? "master/depend_task/" : (taskInstance.isConditionsTask() ? "master/conditions_task/" : "master/task/"));
        return prefix + Utils.getProcessDefinitionId(taskInstance.getProcessDefinitionId()) + "/";
    }
}

