/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.skywalking.plugin;

import java.lang.reflect.Method;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.skywalking.plugin.TaskContext;
import org.apache.dolphinscheduler.skywalking.plugin.Utils;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.RuntimeContext;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;

public class MasterExecThreadMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String OPERATION_NAME_PREFIX = "master/process/";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        TaskContext taskContext = (TaskContext)objInst.getSkyWalkingDynamicField();
        ProcessInstance processInstance = (ProcessInstance)taskContext.getCache();
        ProcessDefinition processDefinition = processInstance.getProcessDefinition();
        String operationName = OPERATION_NAME_PREFIX + Utils.getProjectId(processDefinition.getProjectId()) + "/" + processDefinition.getName();
        AbstractSpan span = ContextManager.createLocalSpan((String)operationName);
        span.setComponent((Component)Utils.DOLPHIN_SCHEDULER);
        Utils.TAG_PROJECT_ID.set(span, String.valueOf(processDefinition.getProjectId()));
        Utils.TAG_PROCESS_INSTANCE_ID.set(span, String.valueOf(processInstance.getId()));
        Utils.TAG_PROCESS_INSTANCE_NAME.set(span, processInstance.getName());
        Utils.TAG_PROCESS_INSTANCE_HOST.set(span, processInstance.getHost());
        Utils.TAG_PROCESS_DEFINITION_ID.set(span, String.valueOf(processInstance.getProcessDefinitionId()));
        Utils.TAG_PROCESS_COMMAND_TYPE.set(span, processInstance.getCommandType().name());
        Utils.TAG_PROCESS_WORKER_GROUP.set(span, processInstance.getWorkerGroup());
        Utils.TAG_PROCESS_TIMEOUT.set(span, String.valueOf(processInstance.getTimeout()));
        Utils.TAG_EXECUTE_METHOD.set(span, Utils.getMethodName(method));
        ContextManager.continued((ContextSnapshot)taskContext.getContextSnapshot());
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        AbstractSpan span = ContextManager.activeSpan();
        RuntimeContext runtimeContext = ContextManager.getRuntimeContext();
        ExecutionStatus executionStatus = (ExecutionStatus)runtimeContext.get((Object)"master_process_execution_status");
        if (executionStatus == null) {
            ProcessInstance processInstance = (ProcessInstance)objInst.getSkyWalkingDynamicField();
            executionStatus = processInstance.getState();
        }
        Utils.TAG_PROCESS_STATE.set(span, executionStatus.getDescp());
        if (!ExecutionStatus.SUCCESS.equals((Object)executionStatus)) {
            span.errorOccurred();
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

