/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.skywalking.plugin;

import java.lang.reflect.Method;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.task.AbstractTask;
import org.apache.dolphinscheduler.skywalking.plugin.TaskContext;
import org.apache.dolphinscheduler.skywalking.plugin.Utils;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;

public class TaskExecuteMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final int DEFAULT_TASK_STATUS_CODE = -1;
    private static final int TASK_PARAMS_MAX_LENGTH = 2048;
    private static final String OPERATION_NAME_PREFIX = "worker/";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        TaskContext taskContext = (TaskContext)objInst.getSkyWalkingDynamicField();
        String operationName = OPERATION_NAME_PREFIX + ((TaskExecutionContext)taskContext.getCache()).getTaskType() + "/" + method.getName();
        AbstractSpan span = ContextManager.createLocalSpan((String)operationName);
        span.setComponent((Component)Utils.DOLPHIN_SCHEDULER);
        Utils.TAG_EXECUTE_METHOD.set(span, Utils.getMethodName(method));
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        AbstractSpan span = ContextManager.activeSpan();
        AbstractTask task = (AbstractTask)objInst;
        int statusCode = task.getExitStatusCode();
        ExecutionStatus status = task.getExitStatus();
        Utils.TAG_TASK_STATE.set(span, status.getDescp());
        if (statusCode != -1 && ExecutionStatus.FAILURE.equals((Object)status)) {
            this.logTaskParams(objInst);
            span.errorOccurred();
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        this.logTaskParams(objInst);
        ContextManager.activeSpan().log(t);
    }

    private void logTaskParams(EnhancedInstance objInst) {
        String taskParams;
        TaskContext taskContext = (TaskContext)objInst.getSkyWalkingDynamicField();
        TaskExecutionContext executionContext = (TaskExecutionContext)taskContext.getCache();
        String limitTaskParams = taskParams = executionContext.getTaskParams();
        if (taskParams.length() > 2048) {
            limitTaskParams = taskParams.substring(2048);
        }
        AbstractSpan span = ContextManager.activeSpan();
        Utils.TAG_TASK_PARAMS.set(span, limitTaskParams);
    }
}

