/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.skywalking.plugin;

import java.lang.reflect.Method;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.utils.EnumUtils;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.skywalking.plugin.TaskContext;
import org.apache.dolphinscheduler.skywalking.plugin.Utils;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;

public class TaskExecuteThreadMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String OPERATION_NAME_PREFIX = "worker/execute/";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        TaskContext taskContext = (TaskContext)objInst.getSkyWalkingDynamicField();
        TaskExecutionContext executionContext = (TaskExecutionContext)taskContext.getCache();
        TaskType type = (TaskType)EnumUtils.getEnum(TaskType.class, (String)executionContext.getTaskType());
        String operationName = OPERATION_NAME_PREFIX + type.getDescp() + "/" + Utils.getProjectId(executionContext.getProjectId()) + "/" + Utils.getProcessDefinitionId(executionContext.getProcessDefineId()) + "/" + executionContext.getTaskName();
        AbstractSpan span = ContextManager.createLocalSpan((String)operationName);
        span.setComponent((Component)Utils.DOLPHIN_SCHEDULER);
        Utils.TAG_PROJECT_ID.set(span, String.valueOf(executionContext.getProjectId()));
        Utils.TAG_PROCESS_DEFINITION_ID.set(span, String.valueOf(executionContext.getProcessDefineId()));
        Utils.TAG_PROCESS_INSTANCE_ID.set(span, String.valueOf(executionContext.getProcessInstanceId()));
        Utils.TAG_TASK_INSTANCE_HOST.set(span, executionContext.getHost());
        Utils.TAG_TASK_INSTANCE_ID.set(span, String.valueOf(executionContext.getTaskInstanceId()));
        Utils.TAG_TASK_EXECUTE_PATH.set(span, executionContext.getExecutePath());
        Utils.TAG_TASK_LOG_PATH.set(span, executionContext.getLogPath());
        Utils.TAG_EXECUTE_METHOD.set(span, Utils.getMethodName(method));
        ContextManager.continued((ContextSnapshot)taskContext.getContextSnapshot());
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

