/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.skywalking.plugin;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.dolphinscheduler.service.queue.TaskPriority;
import org.apache.dolphinscheduler.skywalking.plugin.Utils;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;

public class TaskPriorityQueueConsumerMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String OPERATION_NAME = "master/queue/take";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        TaskPriority taskPriority = (TaskPriority)allArguments[0];
        Map taskContext = taskPriority.getContext();
        AbstractSpan span = ContextManager.createLocalSpan((String)OPERATION_NAME);
        span.setComponent((Component)Utils.DOLPHIN_SCHEDULER);
        Utils.TAG_TASK_ID.set(span, String.valueOf(taskPriority.getTaskId()));
        Utils.TAG_PROCESS_INSTANCE_ID.set(span, String.valueOf(taskPriority.getProcessInstanceId()));
        Tags.LOGIC_ENDPOINT.set(span, "{\"logic-span\":true}");
        Utils.TAG_EXECUTE_METHOD.set(span, Utils.getMethodName(method));
        ContextSnapshot contextSnapshot = (ContextSnapshot)taskContext.get("skywalking_tracing_context");
        ContextManager.continued((ContextSnapshot)contextSnapshot);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        AbstractSpan span = ContextManager.activeSpan();
        boolean handleResult = (Boolean)ret;
        if (!handleResult) {
            span.errorOccurred();
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

