/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.skywalking.plugin;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.dolphinscheduler.service.queue.TaskPriority;
import org.apache.dolphinscheduler.skywalking.plugin.Utils;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;

public class TaskPriorityQueueImplMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String OPERATION_NAME = "master/queue/put";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        boolean isActive = ContextManager.isActive();
        TaskPriority taskPriority = (TaskPriority)allArguments[0];
        AbstractSpan span = ContextManager.createLocalSpan((String)OPERATION_NAME);
        span.setComponent((Component)Utils.DOLPHIN_SCHEDULER);
        Utils.TAG_TASK_ID.set(span, String.valueOf(taskPriority.getTaskId()));
        Utils.TAG_PROCESS_INSTANCE_ID.set(span, String.valueOf(taskPriority.getProcessInstanceId()));
        Tags.LOGIC_ENDPOINT.set(span, "{\"logic-span\":true}");
        Utils.TAG_EXECUTE_METHOD.set(span, Utils.getMethodName(method));
        if (isActive) {
            HashMap<String, ContextSnapshot> taskPriorityContext = taskPriority.getContext();
            if (taskPriorityContext == null) {
                taskPriorityContext = new HashMap<String, ContextSnapshot>();
                taskPriority.setContext(taskPriorityContext);
            }
            taskPriorityContext.put("skywalking_tracing_context", ContextManager.capture());
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

