/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.params;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.spi.params.base.PluginParams;

public class PluginParamsTransfer {
    public static String transferParamsToJson(List<PluginParams> list) {
        return JSONUtils.toJsonString(list);
    }

    public static List<PluginParams> transferJsonToParamsList(String str) {
        return JSONUtils.toList((String)str, PluginParams.class);
    }

    public static Map<String, String> getPluginParamsMap(String paramsJsonStr) {
        List<PluginParams> pluginParams = PluginParamsTransfer.transferJsonToParamsList(paramsJsonStr);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        for (PluginParams param : pluginParams) {
            paramsMap.put(param.getName(), param.getValue() == null ? null : param.getValue().toString());
        }
        return paramsMap;
    }

    public static List<Map<String, Object>> generatePluginParams(String paramsJsonStr, String pluginParamsTemplate) {
        Map paramsMap = JSONUtils.toMap((String)paramsJsonStr, String.class, Object.class);
        return PluginParamsTransfer.generatePluginParams(paramsMap, pluginParamsTemplate);
    }

    public static List<Map<String, Object>> generatePluginParams(Map<String, Object> paramsMap, String pluginParamsTemplate) {
        if (paramsMap == null || paramsMap.isEmpty()) {
            return null;
        }
        List pluginParamsList = (List)JSONUtils.parseObject((String)pluginParamsTemplate, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        pluginParamsList.forEach(pluginParams -> pluginParams.put("value", paramsMap.get(pluginParams.get("field"))));
        return pluginParamsList;
    }
}

