/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.google.common.base.Functions;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public enum DbType {
    MYSQL(0, "mysql"),
    POSTGRESQL(1, "postgresql"),
    HIVE(2, "hive"),
    SPARK(3, "spark"),
    CLICKHOUSE(4, "clickhouse"),
    ORACLE(5, "oracle"),
    SQLSERVER(6, "sqlserver"),
    DB2(7, "db2"),
    PRESTO(8, "presto"),
    H2(9, "h2"),
    REDSHIFT(10, "redshift"),
    ATHENA(11, "athena"),
    TRINO(12, "trino"),
    STARROCKS(13, "starrocks"),
    AZURESQL(14, "azuresql"),
    DAMENG(15, "dameng"),
    OCEANBASE(16, "oceanbase"),
    SSH(17, "ssh"),
    KYUUBI(18, "kyuubi"),
    DATABEND(19, "databend"),
    SNOWFLAKE(20, "snowflake"),
    VERTICA(21, "vertica"),
    HANA(22, "hana"),
    DORIS(23, "doris"),
    ZEPPELIN(24, "zeppelin"),
    SAGEMAKER(25, "sagemaker"),
    K8S(26, "k8s");

    private static final Map<Integer, DbType> DB_TYPE_MAP;
    @EnumValue
    private final int code;
    private final String descp;

    private DbType(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public static DbType of(int type) {
        if (DB_TYPE_MAP.containsKey(type)) {
            return DB_TYPE_MAP.get(type);
        }
        return null;
    }

    public static DbType ofName(String name) {
        return Arrays.stream(DbType.values()).filter(e -> e.name().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException("no such db type"));
    }

    public int getCode() {
        return this.code;
    }

    public String getDescp() {
        return this.descp;
    }

    public boolean isHive() {
        return this == HIVE;
    }

    public boolean isSupportMultipleStatement() {
        return this.isHive() || this == SPARK;
    }

    static {
        DB_TYPE_MAP = Arrays.stream(DbType.values()).collect(Collectors.toMap(DbType::getCode, Functions.identity()));
    }
}

