/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.plugin;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import lombok.Generated;
import org.apache.dolphinscheduler.spi.plugin.PrioritySPI;
import org.apache.dolphinscheduler.spi.plugin.SPIIdentify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrioritySPIFactory<T extends PrioritySPI> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrioritySPIFactory.class);
    private final Map<String, T> map = new HashMap<String, T>();

    public PrioritySPIFactory(Class<T> spiClass) {
        for (PrioritySPI t : ServiceLoader.load(spiClass)) {
            if (this.map.containsKey(t.getIdentify().getName())) {
                this.resolveConflict(t);
                continue;
            }
            this.map.put(t.getIdentify().getName(), t);
        }
    }

    public Map<String, T> getSPIMap() {
        return Collections.unmodifiableMap(this.map);
    }

    private void resolveConflict(T newSPI) {
        SPIIdentify identify = newSPI.getIdentify();
        PrioritySPI oldSPI = (PrioritySPI)this.map.get(identify.getName());
        if (newSPI.compareTo(oldSPI.getIdentify().getPriority()) == 0) {
            throw new IllegalArgumentException(String.format("These two spi plugins has conflict identify name with the same priority: %s, %s", oldSPI.getIdentify(), newSPI.getIdentify()));
        }
        if (newSPI.compareTo(oldSPI.getIdentify().getPriority()) > 0) {
            log.info("The {} plugin has high priority, will override {}", (Object)newSPI.getIdentify(), (Object)oldSPI);
            this.map.put(identify.getName(), newSPI);
        } else {
            log.info("The low plugin {} will be skipped", newSPI);
        }
    }
}

