/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.abs;

import com.azure.core.http.rest.PagedIterable;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobContainerItem;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.specialized.BlockBlobClient;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.ResUploadType;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperate;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbsStorageOperator
implements Closeable,
StorageOperate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbsStorageOperator.class);
    private BlobContainerClient blobContainerClient;
    private BlobServiceClient blobServiceClient;
    private String connectionString;
    private String storageAccountName;
    private String containerName;

    public void init() {
        this.containerName = this.readContainerName();
        this.connectionString = this.readConnectionString();
        this.storageAccountName = this.readAccountName();
        this.blobServiceClient = this.buildBlobServiceClient();
        this.blobContainerClient = this.buildBlobContainerClient();
        this.checkContainerNameExists();
    }

    protected BlobServiceClient buildBlobServiceClient() {
        return new BlobServiceClientBuilder().endpoint("https://" + this.storageAccountName + ".blob.core.windows.net/").connectionString(this.connectionString).buildClient();
    }

    protected BlobContainerClient buildBlobContainerClient() {
        return this.blobServiceClient.getBlobContainerClient(this.containerName);
    }

    protected String readConnectionString() {
        return PropertyUtils.getString((String)"resource.azure.blob.storage.connection.string");
    }

    protected String readContainerName() {
        return PropertyUtils.getString((String)"resource.azure.blob.storage.container.name");
    }

    protected String readAccountName() {
        return PropertyUtils.getString((String)"resource.azure.blob.storage.account.name");
    }

    public void createTenantDirIfNotExists(String tenantCode) throws Exception {
        this.mkdir(tenantCode, this.getAbsResDir(tenantCode));
        this.mkdir(tenantCode, this.getAbsUdfDir(tenantCode));
    }

    public String getAbsResDir(String tenantCode) {
        return String.format("%s/resources", this.getAbsTenantDir(tenantCode));
    }

    public String getAbsUdfDir(String tenantCode) {
        return String.format("%s/udfs", this.getAbsTenantDir(tenantCode));
    }

    public String getAbsTenantDir(String tenantCode) {
        return String.format("%s/%s", this.getGcsDataBasePath(), tenantCode);
    }

    public String getGcsDataBasePath() {
        if ("/".equals(RESOURCE_UPLOAD_PATH)) {
            return "";
        }
        return RESOURCE_UPLOAD_PATH.replaceFirst("/", "");
    }

    public String getResDir(String tenantCode) {
        return this.getAbsResDir(tenantCode) + "/";
    }

    public String getUdfDir(String tenantCode) {
        return this.getAbsUdfDir(tenantCode) + "/";
    }

    public String getResourceFullName(String tenantCode, String fileName) {
        if (fileName.startsWith("/")) {
            fileName.replaceFirst("/", "");
        }
        return String.format("%s/%s", this.getAbsResDir(tenantCode), fileName);
    }

    public String getFileName(ResourceType resourceType, String tenantCode, String fileName) {
        if (fileName.startsWith("/")) {
            fileName = fileName.replaceFirst("/", "");
        }
        return this.getDir(resourceType, tenantCode) + fileName;
    }

    public void download(String srcFilePath, String dstFilePath, boolean overwrite) throws IOException {
        File dstFile = new File(dstFilePath);
        if (dstFile.isDirectory()) {
            Files.delete(dstFile.toPath());
        } else {
            FileUtils.createDirectoryWith755((Path)dstFile.getParentFile().toPath());
        }
        BlobClient blobClient = this.blobContainerClient.getBlobClient(srcFilePath);
        blobClient.downloadToFile(dstFilePath, true);
    }

    public boolean exists(String fullName) throws IOException {
        return this.isObjectExists(fullName);
    }

    protected boolean isObjectExists(String objectName) {
        return this.blobContainerClient.getBlobClient(objectName).exists();
    }

    public boolean delete(String filePath, boolean recursive) throws IOException {
        try {
            if (this.isObjectExists(filePath)) {
                this.blobContainerClient.getBlobClient(filePath).delete();
            }
            return true;
        }
        catch (Exception e) {
            log.error("delete the object error,the resource path is {}", (Object)filePath);
            return false;
        }
    }

    public boolean delete(String fullName, List<String> childrenPathList, boolean recursive) throws IOException {
        childrenPathList.add(fullName);
        boolean result = true;
        for (String filePath : childrenPathList) {
            if (this.delete(filePath, recursive)) continue;
            result = false;
        }
        return result;
    }

    public boolean copy(String srcPath, String dstPath, boolean deleteSource, boolean overwrite) throws IOException {
        BlobClient srcBlobClient = this.blobContainerClient.getBlobClient(srcPath);
        BlockBlobClient dstBlobClient = this.blobContainerClient.getBlobClient(dstPath).getBlockBlobClient();
        dstBlobClient.uploadFromUrl(srcBlobClient.getBlobUrl(), overwrite);
        if (deleteSource) {
            srcBlobClient.delete();
        }
        return true;
    }

    public boolean upload(String tenantCode, String srcFile, String dstPath, boolean deleteSource, boolean overwrite) throws IOException {
        try {
            BlobClient blobClient = this.blobContainerClient.getBlobClient(dstPath);
            blobClient.uploadFromFile(srcFile, overwrite);
            Path srcPath = Paths.get(srcFile, new String[0]);
            if (deleteSource) {
                Files.delete(srcPath);
            }
            return true;
        }
        catch (Exception e) {
            log.error("upload failed,the container is {},the filePath is {}", (Object)this.containerName, (Object)dstPath);
            return false;
        }
    }

    public List<String> vimFile(String tenantCode, String filePath, int skipLineNums, int limit) throws IOException {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            log.error("file path:{} is blank", (Object)filePath);
            return Collections.emptyList();
        }
        BlobClient blobClient = this.blobContainerClient.getBlobClient(filePath);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(blobClient.downloadContent().toBytes())));){
            Stream<String> stream = bufferedReader.lines().skip(skipLineNums).limit(limit);
            List<String> list = stream.collect(Collectors.toList());
            return list;
        }
    }

    public void deleteTenant(String tenantCode) throws Exception {
        this.deleteTenantCode(tenantCode);
    }

    protected void deleteTenantCode(String tenantCode) {
        this.deleteDirectory(this.getResDir(tenantCode));
        this.deleteDirectory(this.getUdfDir(tenantCode));
    }

    public String getDir(ResourceType resourceType, String tenantCode) {
        switch (resourceType) {
            case UDF: {
                return this.getUdfDir(tenantCode);
            }
            case FILE: {
                return this.getResDir(tenantCode);
            }
            case ALL: {
                return this.getGcsDataBasePath();
            }
        }
        return "";
    }

    protected void deleteDirectory(String directoryName) {
        if (this.isObjectExists(directoryName)) {
            this.blobContainerClient.getBlobClient(directoryName).delete();
        }
    }

    public boolean mkdir(String tenantCode, String path) throws IOException {
        String objectName = path + "/";
        if (!this.isObjectExists(objectName)) {
            BlobClient blobClient = this.blobContainerClient.getBlobClient(objectName);
            blobClient.upload((InputStream)new ByteArrayInputStream("".getBytes()), 0L);
        }
        return true;
    }

    @Override
    public void close() throws IOException {
    }

    public ResUploadType returnStorageType() {
        return ResUploadType.ABS;
    }

    public List<StorageEntity> listFilesStatusRecursively(String path, String defaultPath, String tenantCode, ResourceType type) {
        ArrayList<StorageEntity> storageEntityList = new ArrayList<StorageEntity>();
        LinkedList<StorageEntity> foldersToFetch = new LinkedList<StorageEntity>();
        StorageEntity initialEntity = null;
        try {
            initialEntity = this.getFileStatus(path, defaultPath, tenantCode, type);
        }
        catch (Exception e) {
            log.error("error while listing files status recursively, path: {}", (Object)path, (Object)e);
            return storageEntityList;
        }
        foldersToFetch.add(initialEntity);
        while (!foldersToFetch.isEmpty()) {
            String pathToExplore = ((StorageEntity)foldersToFetch.pop()).getFullName();
            try {
                List<StorageEntity> tempList = this.listFilesStatus(pathToExplore, defaultPath, tenantCode, type);
                for (StorageEntity temp : tempList) {
                    if (!temp.isDirectory()) continue;
                    foldersToFetch.add(temp);
                }
                storageEntityList.addAll(tempList);
            }
            catch (Exception e) {
                log.error("error while listing files stat:wus recursively, path: {}", (Object)pathToExplore, (Object)e);
            }
        }
        return storageEntityList;
    }

    public List<StorageEntity> listFilesStatus(String path, String defaultPath, String tenantCode, ResourceType type) throws Exception {
        ArrayList<StorageEntity> storageEntityList = new ArrayList<StorageEntity>();
        PagedIterable blobItems = this.blobContainerClient.listBlobsByHierarchy(path);
        if (blobItems == null) {
            return storageEntityList;
        }
        for (BlobItem blobItem : blobItems) {
            if (path.equals(blobItem.getName())) continue;
            if (blobItem.isPrefix().booleanValue()) {
                String suffix = StringUtils.difference((String)path, (String)blobItem.getName());
                String fileName = StringUtils.difference((String)defaultPath, (String)blobItem.getName());
                StorageEntity entity = new StorageEntity();
                entity.setAlias(suffix);
                entity.setFileName(fileName);
                entity.setFullName(blobItem.getName());
                entity.setDirectory(true);
                entity.setUserName(tenantCode);
                entity.setType(type);
                entity.setSize(0L);
                entity.setCreateTime(null);
                entity.setUpdateTime(null);
                entity.setPfullName(path);
                storageEntityList.add(entity);
                continue;
            }
            String[] aliasArr = blobItem.getName().split("/");
            String alias = aliasArr[aliasArr.length - 1];
            String fileName = StringUtils.difference((String)defaultPath, (String)blobItem.getName());
            StorageEntity entity = new StorageEntity();
            entity.setAlias(alias);
            entity.setFileName(fileName);
            entity.setFullName(blobItem.getName());
            entity.setDirectory(false);
            entity.setUserName(tenantCode);
            entity.setType(type);
            entity.setSize(blobItem.getProperties().getContentLength().longValue());
            entity.setCreateTime(Date.from(blobItem.getProperties().getCreationTime().toInstant()));
            entity.setUpdateTime(Date.from(blobItem.getProperties().getLastModified().toInstant()));
            entity.setPfullName(path);
            storageEntityList.add(entity);
        }
        return storageEntityList;
    }

    public StorageEntity getFileStatus(String path, String defaultPath, String tenantCode, ResourceType type) throws Exception {
        if (path.endsWith("/")) {
            String alias = this.findDirAlias(path);
            String fileName = StringUtils.difference((String)defaultPath, (String)path);
            StorageEntity entity = new StorageEntity();
            entity.setAlias(alias);
            entity.setFileName(fileName);
            entity.setFullName(path);
            entity.setDirectory(true);
            entity.setUserName(tenantCode);
            entity.setType(type);
            entity.setSize(0L);
            return entity;
        }
        if (this.isObjectExists(path)) {
            BlobClient blobClient = this.blobContainerClient.getBlobClient(path);
            String[] aliasArr = blobClient.getBlobName().split("/");
            String alias = aliasArr[aliasArr.length - 1];
            String fileName = StringUtils.difference((String)defaultPath, (String)blobClient.getBlobName());
            StorageEntity entity = new StorageEntity();
            entity.setAlias(alias);
            entity.setFileName(fileName);
            entity.setFullName(blobClient.getBlobName());
            entity.setDirectory(false);
            entity.setUserName(tenantCode);
            entity.setType(type);
            entity.setSize(blobClient.getProperties().getBlobSize());
            entity.setCreateTime(Date.from(blobClient.getProperties().getCreationTime().toInstant()));
            entity.setUpdateTime(Date.from(blobClient.getProperties().getLastModified().toInstant()));
            return entity;
        }
        throw new FileNotFoundException("Object is not found in ABS container: " + this.containerName);
    }

    private String findDirAlias(String dirPath) {
        if (!dirPath.endsWith("/")) {
            return dirPath;
        }
        Path path = Paths.get(dirPath, new String[0]);
        return path.getName(path.getNameCount() - 1) + "/";
    }

    public void checkContainerNameExists() {
        if (StringUtils.isBlank((CharSequence)this.containerName)) {
            throw new IllegalArgumentException(this.containerName + " is blank");
        }
        boolean exist = false;
        for (BlobContainerItem item : this.blobServiceClient.listBlobContainers()) {
            if (!this.containerName.equals(item.getName())) continue;
            exist = true;
            break;
        }
        if (!exist) {
            throw new IllegalArgumentException("containerName: " + this.containerName + " is not exists, you need to create them by yourself");
        }
        log.info("containerName: {} has been found", (Object)this.containerName);
    }

    @Generated
    public BlobContainerClient getBlobContainerClient() {
        return this.blobContainerClient;
    }

    @Generated
    public BlobServiceClient getBlobServiceClient() {
        return this.blobServiceClient;
    }

    @Generated
    public String getConnectionString() {
        return this.connectionString;
    }

    @Generated
    public String getStorageAccountName() {
        return this.storageAccountName;
    }

    @Generated
    public String getContainerName() {
        return this.containerName;
    }

    @Generated
    public void setBlobContainerClient(BlobContainerClient blobContainerClient) {
        this.blobContainerClient = blobContainerClient;
    }

    @Generated
    public void setBlobServiceClient(BlobServiceClient blobServiceClient) {
        this.blobServiceClient = blobServiceClient;
    }

    @Generated
    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    @Generated
    public void setStorageAccountName(String storageAccountName) {
        this.storageAccountName = storageAccountName;
    }

    @Generated
    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbsStorageOperator)) {
            return false;
        }
        AbsStorageOperator other = (AbsStorageOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BlobContainerClient this$blobContainerClient = this.getBlobContainerClient();
        BlobContainerClient other$blobContainerClient = other.getBlobContainerClient();
        if (this$blobContainerClient == null ? other$blobContainerClient != null : !this$blobContainerClient.equals(other$blobContainerClient)) {
            return false;
        }
        BlobServiceClient this$blobServiceClient = this.getBlobServiceClient();
        BlobServiceClient other$blobServiceClient = other.getBlobServiceClient();
        if (this$blobServiceClient == null ? other$blobServiceClient != null : !this$blobServiceClient.equals(other$blobServiceClient)) {
            return false;
        }
        String this$connectionString = this.getConnectionString();
        String other$connectionString = other.getConnectionString();
        if (this$connectionString == null ? other$connectionString != null : !this$connectionString.equals(other$connectionString)) {
            return false;
        }
        String this$storageAccountName = this.getStorageAccountName();
        String other$storageAccountName = other.getStorageAccountName();
        if (this$storageAccountName == null ? other$storageAccountName != null : !this$storageAccountName.equals(other$storageAccountName)) {
            return false;
        }
        String this$containerName = this.getContainerName();
        String other$containerName = other.getContainerName();
        return !(this$containerName == null ? other$containerName != null : !this$containerName.equals(other$containerName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbsStorageOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BlobContainerClient $blobContainerClient = this.getBlobContainerClient();
        result = result * 59 + ($blobContainerClient == null ? 43 : $blobContainerClient.hashCode());
        BlobServiceClient $blobServiceClient = this.getBlobServiceClient();
        result = result * 59 + ($blobServiceClient == null ? 43 : $blobServiceClient.hashCode());
        String $connectionString = this.getConnectionString();
        result = result * 59 + ($connectionString == null ? 43 : $connectionString.hashCode());
        String $storageAccountName = this.getStorageAccountName();
        result = result * 59 + ($storageAccountName == null ? 43 : $storageAccountName.hashCode());
        String $containerName = this.getContainerName();
        result = result * 59 + ($containerName == null ? 43 : $containerName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbsStorageOperator(blobContainerClient=" + this.getBlobContainerClient() + ", blobServiceClient=" + this.getBlobServiceClient() + ", connectionString=" + this.getConnectionString() + ", storageAccountName=" + this.getStorageAccountName() + ", containerName=" + this.getContainerName() + ")";
    }
}

