/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.api;

import java.util.Optional;
import java.util.ServiceLoader;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperate;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperateFactory;
import org.apache.dolphinscheduler.plugin.storage.api.StorageType;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class StorageConfiguration {
    @Bean
    public StorageOperate storageOperate() {
        Optional<StorageType> storageTypeOptional = StorageType.getStorageType(PropertyUtils.getUpperCaseString((String)"resource.storage.type"));
        Optional<StorageOperate> storageOperate = storageTypeOptional.map(storageType -> {
            ServiceLoader<StorageOperateFactory> storageOperateFactories = ServiceLoader.load(StorageOperateFactory.class);
            for (StorageOperateFactory storageOperateFactory : storageOperateFactories) {
                if (storageOperateFactory.getStorageOperate() != storageType) continue;
                return storageOperateFactory.createStorageOperate();
            }
            return null;
        });
        return storageOperate.orElse(null);
    }
}

