/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.api;

import java.io.IOException;
import java.util.List;
import org.apache.dolphinscheduler.common.enums.ResUploadType;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;
import org.apache.dolphinscheduler.spi.enums.ResourceType;

public interface StorageOperate {
    public static final String RESOURCE_UPLOAD_PATH = PropertyUtils.getString((String)"resource.storage.upload.base.path", (String)"/dolphinscheduler");

    public void createTenantDirIfNotExists(String var1) throws Exception;

    public String getResDir(String var1);

    public String getUdfDir(String var1);

    public boolean mkdir(String var1, String var2) throws IOException;

    public String getResourceFullName(String var1, String var2);

    default public String getResourceFileName(String tenantCode, String fullName) {
        String resDir = this.getResDir(tenantCode);
        String filenameReplaceResDir = fullName.replaceFirst(resDir, "");
        if (!filenameReplaceResDir.equals(fullName)) {
            return filenameReplaceResDir;
        }
        return filenameReplaceResDir.contains("resources") ? filenameReplaceResDir.split(String.format("%s/", "resources"))[1] : filenameReplaceResDir;
    }

    public String getFileName(ResourceType var1, String var2, String var3);

    public boolean exists(String var1) throws IOException;

    public boolean delete(String var1, boolean var2) throws IOException;

    public boolean delete(String var1, List<String> var2, boolean var3) throws IOException;

    public boolean copy(String var1, String var2, boolean var3, boolean var4) throws IOException;

    public String getDir(ResourceType var1, String var2);

    public boolean upload(String var1, String var2, String var3, boolean var4, boolean var5) throws IOException;

    public void download(String var1, String var2, boolean var3) throws IOException;

    public List<String> vimFile(String var1, String var2, int var3, int var4) throws IOException;

    public void deleteTenant(String var1) throws Exception;

    public ResUploadType returnStorageType();

    public List<StorageEntity> listFilesStatusRecursively(String var1, String var2, String var3, ResourceType var4);

    public List<StorageEntity> listFilesStatus(String var1, String var2, String var3, ResourceType var4) throws Exception;

    public StorageEntity getFileStatus(String var1, String var2, String var3, ResourceType var4) throws Exception;
}

