/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.api;

import java.util.Optional;

public enum StorageType {
    LOCAL(0, "LOCAL"),
    HDFS(1, "HDFS"),
    OSS(2, "OSS"),
    S3(3, "S3"),
    GCS(4, "GCS"),
    ABS(5, "ABS"),
    OBS(6, "OBS");

    private final int code;
    private final String name;

    private StorageType(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static Optional<StorageType> getStorageType(String name) {
        for (StorageType storageType : StorageType.values()) {
            if (!storageType.getName().equals(name)) continue;
            return Optional.of(storageType);
        }
        return Optional.empty();
    }
}

