/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.dq;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.CommonUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractYarnTask;
import org.apache.dolphinscheduler.plugin.task.api.DataQualityTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.dataquality.DataQualityParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.ArgsUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.dq.rule.RuleManager;
import org.apache.dolphinscheduler.plugin.task.dq.rule.parameter.DataQualityConfiguration;
import org.apache.dolphinscheduler.plugin.task.dq.utils.SparkArgsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataQualityTask
extends AbstractYarnTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataQualityTask.class);
    private static final String SPARK_COMMAND = "${SPARK_HOME}/bin/spark-submit";
    private DataQualityParameters dataQualityParameters;
    private final TaskExecutionContext dqTaskExecutionContext;

    public DataQualityTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.dqTaskExecutionContext = taskExecutionContext;
    }

    public void init() {
        this.dataQualityParameters = (DataQualityParameters)JSONUtils.parseObject((String)this.dqTaskExecutionContext.getTaskParams(), DataQualityParameters.class);
        log.info("Initialize data quality task params {}", (Object)JSONUtils.toPrettyJsonString((Object)this.dataQualityParameters));
        if (null == this.dataQualityParameters) {
            log.error("data quality params is null");
            return;
        }
        if (!this.dataQualityParameters.checkParameters()) {
            throw new RuntimeException("data quality task params is not valid");
        }
        Map inputParameter = this.dataQualityParameters.getRuleInputParameter();
        for (Map.Entry entry : inputParameter.entrySet()) {
            if (entry == null || entry.getValue() == null) continue;
            entry.setValue(((String)entry.getValue()).trim());
        }
        DataQualityTaskExecutionContext dataQualityTaskExecutionContext = this.dqTaskExecutionContext.getDataQualityTaskExecutionContext();
        this.operateInputParameter(inputParameter, dataQualityTaskExecutionContext);
        RuleManager ruleManager = new RuleManager(inputParameter, dataQualityTaskExecutionContext);
        DataQualityConfiguration dataQualityConfiguration = ruleManager.generateDataQualityParameter();
        log.info("data quality configuration: {}", (Object)JSONUtils.toPrettyJsonString((Object)dataQualityConfiguration));
        this.dataQualityParameters.getSparkParameters().setMainArgs("\"" + DataQualityTask.replaceDoubleBrackets(StringEscapeUtils.escapeJava((String)JSONUtils.toJsonString((Object)dataQualityConfiguration))) + "\"");
        this.setMainJarName();
    }

    private void operateInputParameter(Map<String, String> inputParameter, DataQualityTaskExecutionContext dataQualityTaskExecutionContext) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime time = LocalDateTime.now();
        String now = df.format(time);
        inputParameter.put("rule_id", String.valueOf(dataQualityTaskExecutionContext.getRuleId()));
        inputParameter.put("rule_type", String.valueOf(dataQualityTaskExecutionContext.getRuleType()));
        inputParameter.put("rule_name", ArgsUtils.wrapperSingleQuotes((String)dataQualityTaskExecutionContext.getRuleName()));
        inputParameter.put("create_time", ArgsUtils.wrapperSingleQuotes((String)now));
        inputParameter.put("update_time", ArgsUtils.wrapperSingleQuotes((String)now));
        inputParameter.put("process_definition_id", String.valueOf(this.dqTaskExecutionContext.getProcessDefineId()));
        inputParameter.put("process_instance_id", String.valueOf(this.dqTaskExecutionContext.getProcessInstanceId()));
        inputParameter.put("task_instance_id", String.valueOf(this.dqTaskExecutionContext.getTaskInstanceId()));
        if (StringUtils.isEmpty((CharSequence)inputParameter.get("data_time"))) {
            inputParameter.put("data_time", ArgsUtils.wrapperSingleQuotes((String)now));
        }
        if (StringUtils.isNotEmpty((CharSequence)inputParameter.get("regexp_pattern"))) {
            inputParameter.put("regexp_pattern", StringEscapeUtils.escapeJava((String)StringEscapeUtils.escapeJava((String)inputParameter.get("regexp_pattern"))));
        }
        if (StringUtils.isNotEmpty((CharSequence)dataQualityTaskExecutionContext.getHdfsPath())) {
            inputParameter.put("error_output_path", dataQualityTaskExecutionContext.getHdfsPath() + "/" + this.dqTaskExecutionContext.getProcessDefineId() + "_" + this.dqTaskExecutionContext.getProcessInstanceId() + "_" + this.dqTaskExecutionContext.getTaskName());
        } else {
            inputParameter.put("error_output_path", "");
        }
    }

    protected String getScript() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(SPARK_COMMAND);
        args.addAll(SparkArgsUtils.buildArgs(this.dataQualityParameters.getSparkParameters()));
        return args.stream().collect(Collectors.joining(" "));
    }

    protected Map<String, String> getProperties() {
        return ParameterUtils.convert((Map)this.dqTaskExecutionContext.getPrepareParamsMap());
    }

    protected void setMainJarName() {
        ResourceInfo mainJar = new ResourceInfo();
        mainJar.setResourceName(CommonUtils.getDataQualityJarPath());
        this.dataQualityParameters.getSparkParameters().setMainJar(mainJar);
    }

    public AbstractParameters getParameters() {
        return this.dataQualityParameters;
    }

    private static String replaceDoubleBrackets(String mainParameter) {
        if ((mainParameter = mainParameter.replace("{{", "{ {").replace("}}", "} }")).contains("{{") || mainParameter.contains("}}")) {
            return DataQualityTask.replaceDoubleBrackets(mainParameter);
        }
        return mainParameter;
    }
}

