/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.emr;

import com.amazonaws.SdkBaseException;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsResult;
import com.amazonaws.services.elasticmapreduce.model.CancelStepsInfo;
import com.amazonaws.services.elasticmapreduce.model.CancelStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.CancelStepsRequestStatus;
import com.amazonaws.services.elasticmapreduce.model.CancelStepsResult;
import com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeStepResult;
import com.amazonaws.services.elasticmapreduce.model.StepState;
import com.amazonaws.services.elasticmapreduce.model.StepStatus;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.emr.AbstractEmrTask;
import org.apache.dolphinscheduler.plugin.task.emr.EmrTaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmrAddStepsTask
extends AbstractEmrTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmrAddStepsTask.class);
    private String stepId;
    private final HashSet<String> waitingStateSet = Sets.newHashSet((Object[])new String[]{StepState.PENDING.toString(), StepState.CANCEL_PENDING.toString(), StepState.RUNNING.toString()});

    protected EmrAddStepsTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
    }

    public List<String> getApplicationIds() throws TaskException {
        return Collections.emptyList();
    }

    public void submitApplication() throws TaskException {
        StepStatus stepStatus = null;
        try {
            AddJobFlowStepsRequest addJobFlowStepsRequest = this.createAddJobFlowStepsRequest();
            AddJobFlowStepsResult result = this.emrClient.addJobFlowSteps(addJobFlowStepsRequest);
            this.clusterId = addJobFlowStepsRequest.getJobFlowId();
            this.stepId = (String)result.getStepIds().get(0);
            this.setAppIds(this.clusterId + "-" + this.stepId);
            stepStatus = this.getStepStatus();
        }
        catch (SdkBaseException | EmrTaskException e) {
            try {
                log.error("emr task submit failed with error", e);
                throw new TaskException("emr task submit fail", e);
            }
            catch (Throwable throwable) {
                int exitStatusCode = this.calculateExitStatusCode(stepStatus);
                this.setExitStatusCode(exitStatusCode);
                log.info("emr task finished with step status : {}", stepStatus);
                throw throwable;
            }
        }
        int exitStatusCode = this.calculateExitStatusCode(stepStatus);
        this.setExitStatusCode(exitStatusCode);
        log.info("emr task finished with step status : {}", (Object)stepStatus);
    }

    public void trackApplicationStatus() throws TaskException {
        StepStatus stepStatus = this.getStepStatus();
        try {
            while (this.waitingStateSet.contains(stepStatus.getState())) {
                TimeUnit.SECONDS.sleep(10L);
                stepStatus = this.getStepStatus();
            }
        }
        catch (SdkBaseException | EmrTaskException e) {
            log.error("emr task failed with error", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TaskException("Execute emr task failed", (Throwable)e);
        }
        finally {
            int exitStatusCode = this.calculateExitStatusCode(stepStatus);
            this.setExitStatusCode(exitStatusCode);
            log.info("emr task finished with step status : {}", (Object)stepStatus);
        }
    }

    protected AddJobFlowStepsRequest createAddJobFlowStepsRequest() {
        AddJobFlowStepsRequest addJobFlowStepsRequest;
        try {
            addJobFlowStepsRequest = (AddJobFlowStepsRequest)objectMapper.readValue(this.emrParameters.getStepsDefineJson(), AddJobFlowStepsRequest.class);
        }
        catch (JsonProcessingException e) {
            throw new EmrTaskException("can not parse AddJobFlowStepsRequest from json", e);
        }
        if (addJobFlowStepsRequest.getSteps().size() > 1) {
            throw new EmrTaskException("ds emr addJobFlowStepsTask only support one step");
        }
        return addJobFlowStepsRequest;
    }

    private int calculateExitStatusCode(StepStatus stepStatus) {
        if (stepStatus == null) {
            return -1;
        }
        String state = stepStatus.getState();
        StepState stepState = StepState.valueOf((String)state);
        switch (stepState) {
            case COMPLETED: {
                return 0;
            }
            case CANCELLED: {
                return 137;
            }
        }
        return -1;
    }

    private StepStatus getStepStatus() {
        DescribeStepRequest describeStepRequest = new DescribeStepRequest().withClusterId(this.clusterId).withStepId(this.stepId);
        DescribeStepResult result = this.emrClient.describeStep(describeStepRequest);
        if (result == null) {
            throw new EmrTaskException("fetch step status failed");
        }
        StepStatus stepStatus = result.getStep().getStatus();
        log.info("emr step [clusterId:{}, stepId:{}] running with status:{}", new Object[]{this.clusterId, this.stepId, stepStatus});
        return stepStatus;
    }

    public void cancelApplication() throws TaskException {
        log.info("trying cancel emr step, taskId:{}, clusterId:{}, stepId:{}", new Object[]{this.taskExecutionContext.getTaskInstanceId(), this.clusterId, this.stepId});
        CancelStepsRequest cancelStepsRequest = new CancelStepsRequest().withClusterId(this.clusterId).withStepIds(new String[]{this.stepId});
        CancelStepsResult cancelStepsResult = this.emrClient.cancelSteps(cancelStepsRequest);
        if (cancelStepsResult == null) {
            throw new EmrTaskException("cancel emr step failed");
        }
        CancelStepsInfo cancelEmrStepInfo = cancelStepsResult.getCancelStepsInfoList().stream().filter(cancelStepsInfo -> cancelStepsInfo.getStepId().equals(this.stepId)).findFirst().orElseThrow(() -> new EmrTaskException("cancel emr step failed"));
        if (CancelStepsRequestStatus.FAILED.toString().equals(cancelEmrStepInfo.getStatus())) {
            throw new EmrTaskException("cancel emr step failed, message:" + cancelEmrStepInfo.getReason());
        }
        log.info("the result of cancel emr step is:{}", (Object)cancelStepsResult);
    }
}

