/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.emr;

import com.amazonaws.SdkBaseException;
import com.amazonaws.services.elasticmapreduce.model.ClusterState;
import com.amazonaws.services.elasticmapreduce.model.ClusterStateChangeReason;
import com.amazonaws.services.elasticmapreduce.model.ClusterStateChangeReasonCode;
import com.amazonaws.services.elasticmapreduce.model.ClusterStatus;
import com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeClusterResult;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowResult;
import com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest;
import com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsResult;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.emr.AbstractEmrTask;
import org.apache.dolphinscheduler.plugin.task.emr.EmrTaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmrJobFlowTask
extends AbstractEmrTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmrJobFlowTask.class);
    private final HashSet<String> waitingStateSet = Sets.newHashSet((Object[])new String[]{ClusterState.STARTING.toString(), ClusterState.BOOTSTRAPPING.toString(), ClusterState.RUNNING.toString()});

    protected EmrJobFlowTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
    }

    public List<String> getApplicationIds() throws TaskException {
        return Collections.emptyList();
    }

    public void submitApplication() throws TaskException {
        ClusterStatus clusterStatus = null;
        try {
            RunJobFlowRequest runJobFlowRequest = this.createRunJobFlowRequest();
            RunJobFlowResult result = this.emrClient.runJobFlow(runJobFlowRequest);
            this.clusterId = result.getJobFlowId();
            this.setAppIds(this.clusterId);
            clusterStatus = this.getClusterStatus();
        }
        catch (SdkBaseException | EmrTaskException e) {
            try {
                log.error("emr task submit failed with error", e);
                throw new TaskException("emr task submit failed", e);
            }
            catch (Throwable throwable) {
                int exitStatusCode = this.calculateExitStatusCode(clusterStatus);
                this.setExitStatusCode(exitStatusCode);
                log.info("emr task finished with cluster status : {}", clusterStatus);
                throw throwable;
            }
        }
        int exitStatusCode = this.calculateExitStatusCode(clusterStatus);
        this.setExitStatusCode(exitStatusCode);
        log.info("emr task finished with cluster status : {}", (Object)clusterStatus);
    }

    public void trackApplicationStatus() throws TaskException {
        ClusterStatus clusterStatus = null;
        try {
            clusterStatus = this.getClusterStatus();
            while (this.waitingStateSet.contains(clusterStatus.getState())) {
                TimeUnit.SECONDS.sleep(10L);
                clusterStatus = this.getClusterStatus();
            }
        }
        catch (SdkBaseException | EmrTaskException e) {
            log.error("emr task failed with error", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TaskException("Execute emr task failed", (Throwable)e);
        }
        finally {
            int exitStatusCode = this.calculateExitStatusCode(clusterStatus);
            this.setExitStatusCode(exitStatusCode);
            log.info("emr task finished with cluster status : {}", (Object)clusterStatus);
        }
    }

    protected RunJobFlowRequest createRunJobFlowRequest() {
        RunJobFlowRequest runJobFlowRequest;
        try {
            runJobFlowRequest = (RunJobFlowRequest)objectMapper.readValue(this.emrParameters.getJobFlowDefineJson(), RunJobFlowRequest.class);
        }
        catch (JsonProcessingException e) {
            throw new EmrTaskException("can not parse RunJobFlowRequest from json", e);
        }
        return runJobFlowRequest;
    }

    private int calculateExitStatusCode(ClusterStatus clusterStatus) {
        if (clusterStatus == null) {
            return -1;
        }
        String state = clusterStatus.getState();
        ClusterStateChangeReason stateChangeReason = clusterStatus.getStateChangeReason();
        ClusterState clusterState = ClusterState.valueOf((String)state);
        switch (clusterState) {
            case WAITING: {
                return 0;
            }
            case TERMINATED: 
            case TERMINATING: {
                String code = stateChangeReason.getCode();
                if (code != null && code.equalsIgnoreCase(ClusterStateChangeReasonCode.ALL_STEPS_COMPLETED.toString())) {
                    return 0;
                }
                return 137;
            }
        }
        return -1;
    }

    private ClusterStatus getClusterStatus() {
        DescribeClusterRequest describeClusterRequest = new DescribeClusterRequest().withClusterId(this.clusterId);
        DescribeClusterResult result = this.emrClient.describeCluster(describeClusterRequest);
        if (result == null) {
            throw new EmrTaskException("fetch cluster status failed");
        }
        ClusterStatus clusterStatus = result.getCluster().getStatus();
        log.info("emr cluster [clusterId:{}] running with status:{}", (Object)this.clusterId, (Object)clusterStatus);
        return clusterStatus;
    }

    public void cancelApplication() throws TaskException {
        log.info("trying terminate job flow, taskId:{}, clusterId:{}", (Object)this.taskExecutionContext.getTaskInstanceId(), (Object)this.clusterId);
        TerminateJobFlowsRequest terminateJobFlowsRequest = new TerminateJobFlowsRequest().withJobFlowIds(new String[]{this.clusterId});
        TerminateJobFlowsResult terminateJobFlowsResult = this.emrClient.terminateJobFlows(terminateJobFlowsRequest);
        log.info("the result of terminate job flow is:{}", (Object)terminateJobFlowsResult);
    }
}

