/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.flink;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.flink.FlinkArgsUtils;
import org.apache.dolphinscheduler.plugin.task.flink.FlinkParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static String getInitScriptFilePath(TaskExecutionContext taskExecutionContext) {
        return String.format("%s/%s_init.sql", taskExecutionContext.getExecutePath(), taskExecutionContext.getTaskAppId());
    }

    public static String getScriptFilePath(TaskExecutionContext taskExecutionContext) {
        return String.format("%s/%s_node.sql", taskExecutionContext.getExecutePath(), taskExecutionContext.getTaskAppId());
    }

    public static void generateScriptFile(TaskExecutionContext taskExecutionContext, FlinkParameters flinkParameters) {
        String initScriptFilePath = FileUtils.getInitScriptFilePath(taskExecutionContext);
        String scriptFilePath = FileUtils.getScriptFilePath(taskExecutionContext);
        String initOptionsString = StringUtils.join(FlinkArgsUtils.buildInitOptionsForSql(flinkParameters), (String)";\n").concat(";\n");
        FileUtils.writeScriptFile(initScriptFilePath, initOptionsString + flinkParameters.getInitScript());
        FileUtils.writeScriptFile(scriptFilePath, flinkParameters.getRawScript());
    }

    private static void writeScriptFile(String scriptFileFullPath, String script) {
        File scriptFile = new File(scriptFileFullPath);
        Path path = scriptFile.toPath();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Flink Script file exists in path: %s before creation and cannot be deleted", path), e);
            }
        }
        Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwxr-xr-x");
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(perms);
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                Files.createFile(path, new FileAttribute[0]);
            } else {
                if (!scriptFile.getParentFile().exists()) {
                    scriptFile.getParentFile().mkdirs();
                }
                Files.createFile(path, attr);
            }
            if (StringUtils.isNotEmpty((CharSequence)script)) {
                String replacedScript = script.replaceAll("\\r\\n", "\n");
                FileUtils.writeStringToFile(scriptFile, replacedScript, StandardOpenOption.APPEND);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Generate flink SQL script error", e);
        }
    }

    private static void writeStringToFile(File file, String content, StandardOpenOption standardOpenOption) {
        try {
            log.info("Writing content: " + content);
            log.info("To file: " + file.getAbsolutePath());
            Files.write(file.getAbsoluteFile().toPath(), content.getBytes(StandardCharsets.UTF_8), standardOpenOption);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing file: " + file.getAbsoluteFile(), e);
        }
    }
}

