/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.hivecli;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.ShellCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.resource.ResourceContext;
import org.apache.dolphinscheduler.plugin.task.api.shell.IShellInterceptorBuilder;
import org.apache.dolphinscheduler.plugin.task.api.shell.ShellInterceptorBuilderFactory;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.hivecli.HiveCliParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCliTask
extends AbstractRemoteTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HiveCliTask.class);
    private HiveCliParameters hiveCliParameters;
    private final ShellCommandExecutor shellCommandExecutor;
    private final TaskExecutionContext taskExecutionContext;

    public HiveCliTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
        this.shellCommandExecutor = new ShellCommandExecutor(arg_0 -> ((HiveCliTask)this).logHandle(arg_0), taskExecutionContext);
    }

    public List<String> getApplicationIds() throws TaskException {
        return Collections.emptyList();
    }

    public void init() {
        log.info("hiveCli task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.hiveCliParameters = (HiveCliParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), HiveCliParameters.class));
        if (!this.hiveCliParameters.checkParameters()) {
            throw new TaskException("hiveCli task params is not valid");
        }
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        try {
            IShellInterceptorBuilder shellActuatorBuilder = ShellInterceptorBuilderFactory.newBuilder().appendScript(this.buildCommand());
            TaskResponse taskResponse = this.shellCommandExecutor.run(shellActuatorBuilder, taskCallBack);
            this.setExitStatusCode(taskResponse.getExitStatusCode());
            this.setAppIds(taskResponse.getAppIds());
            this.setProcessId(taskResponse.getProcessId());
            this.setTaskOutputParams(this.shellCommandExecutor.getTaskOutputParams());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("The current HiveCLI Task has been interrupted", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("The current HiveCLI Task has been interrupted", (Throwable)e);
        }
        catch (Exception e) {
            log.error("hiveCli task failure", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("run hiveCli task error", (Throwable)e);
        }
    }

    public void submitApplication() throws TaskException {
    }

    public void trackApplicationStatus() throws TaskException {
    }

    protected String buildCommand() {
        ArrayList<String> args = new ArrayList<String>();
        String type = this.hiveCliParameters.getHiveCliTaskExecutionType();
        String sqlContent = "";
        String resourceFileName = "";
        if ("FILE".equals(type)) {
            List<ResourceInfo> resourceInfos = this.hiveCliParameters.getResourceList();
            if (resourceInfos.size() > 1) {
                log.warn("more than 1 files detected, use the first one by default");
            }
            try {
                resourceFileName = resourceInfos.get(0).getResourceName();
                ResourceContext resourceContext = this.taskExecutionContext.getResourceContext();
                sqlContent = FileUtils.readFileToString((File)new File(resourceContext.getResourceItem(resourceFileName).getResourceAbsolutePathInLocal()), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                log.error("read hive sql content from file {} error ", (Object)resourceFileName, (Object)e);
                throw new TaskException("read hive sql content error", (Throwable)e);
            }
        } else {
            sqlContent = this.hiveCliParameters.getHiveSqlScript();
        }
        Map paramsMap = this.taskExecutionContext.getPrepareParamsMap();
        sqlContent = ParameterUtils.convertParameterPlaceholders((String)sqlContent, (Map)ParameterUtils.convert((Map)paramsMap));
        log.info("HiveCli sql content: {}", (Object)sqlContent);
        String sqlFilePath = this.generateSqlScriptFile(sqlContent);
        args.add("hive -f");
        args.add(new File(sqlFilePath).getName());
        String hiveCliOptions = this.hiveCliParameters.getHiveCliOptions();
        if (StringUtils.isNotEmpty((CharSequence)hiveCliOptions)) {
            args.add(hiveCliOptions);
        }
        String command = String.join((CharSequence)" ", args);
        log.info("hiveCli task command: {}", (Object)command);
        return command;
    }

    public AbstractParameters getParameters() {
        return this.hiveCliParameters;
    }

    public void cancelApplication() throws TaskException {
        try {
            this.shellCommandExecutor.cancelApplication();
        }
        catch (Exception e) {
            throw new TaskException("cancel application error", (Throwable)e);
        }
    }

    protected String generateSqlScriptFile(String rawScript) {
        String scriptFileName = String.format("%s/%s_node.sql", this.taskExecutionContext.getExecutePath(), this.taskExecutionContext.getTaskAppId());
        File file = new File(scriptFileName);
        Path path = file.toPath();
        if (!Files.exists(path, new LinkOption[0])) {
            String script = rawScript.replaceAll("\\r\\n", "\n");
            Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwxr-xr-x");
            FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(perms);
            try {
                if (OSUtils.isWindows().booleanValue()) {
                    Files.createFile(path, new FileAttribute[0]);
                } else {
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    Files.createFile(path, attr);
                }
                Files.write(path, script.getBytes(), StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                log.error("generate hivecli sql script error", (Throwable)e);
                throw new TaskException("generate hivecli sql script error", (Throwable)e);
            }
        }
        return scriptFileName;
    }
}

