/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.http;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.DataType;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.http.HttpMethod;
import org.apache.dolphinscheduler.plugin.task.http.HttpParameters;
import org.apache.dolphinscheduler.plugin.task.http.HttpParametersType;
import org.apache.dolphinscheduler.plugin.task.http.HttpProperty;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTask
extends AbstractTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpTask.class);
    protected String output;
    private HttpParameters httpParameters;
    private TaskExecutionContext taskExecutionContext;

    public HttpTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() {
        this.httpParameters = (HttpParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), HttpParameters.class));
        log.info("Initialize http task params {}", (Object)JSONUtils.toPrettyJsonString((Object)((Object)this.httpParameters)));
        if (this.httpParameters == null || !this.httpParameters.checkParameters()) {
            throw new RuntimeException("http task params is not valid");
        }
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        long startTime = System.currentTimeMillis();
        String formatTimeStamp = DateUtils.formatTimeStamp((long)startTime);
        String statusCode = null;
        String body = null;
        try (CloseableHttpClient client = this.createHttpClient();
             CloseableHttpResponse response = this.sendRequest(client);){
            statusCode = String.valueOf(this.getStatusCode(response));
            body = this.getResponseBody(response);
            this.exitStatusCode = this.validResponse(body, statusCode);
            this.addDefaultOutput(body);
            long costTime = System.currentTimeMillis() - startTime;
            log.info("startTime: {}, httpUrl: {}, httpMethod: {}, costTime : {} milliseconds, statusCode : {}, body : {}, log : {}", new Object[]{formatTimeStamp, this.httpParameters.getUrl(), this.httpParameters.getHttpMethod(), costTime, statusCode, body, this.output});
        }
        catch (Exception e) {
            this.appendMessage(e.toString());
            this.exitStatusCode = -1;
            log.error("httpUrl[" + this.httpParameters.getUrl() + "] connection failed\uff1a" + this.output, (Throwable)e);
            throw new TaskException("Execute http task failed", (Throwable)e);
        }
    }

    public void cancel() throws TaskException {
    }

    protected CloseableHttpResponse sendRequest(CloseableHttpClient client) throws IOException {
        RequestBuilder builder = this.createRequestBuilder();
        Map paramsMap = this.taskExecutionContext.getPrepareParamsMap();
        ArrayList<HttpProperty> httpPropertyList = new ArrayList<HttpProperty>();
        if (CollectionUtils.isNotEmpty(this.httpParameters.getHttpParams())) {
            for (HttpProperty httpProperty : this.httpParameters.getHttpParams()) {
                String jsonObject = JSONUtils.toJsonString((Object)httpProperty);
                String params = ParameterUtils.convertParameterPlaceholders((String)jsonObject, (Map)ParameterUtils.convert((Map)paramsMap));
                log.info("http request params\uff1a{}", (Object)params);
                httpPropertyList.add((HttpProperty)JSONUtils.parseObject((String)params, HttpProperty.class));
            }
        }
        String httpBody = ParameterUtils.convertParameterPlaceholders((String)this.httpParameters.getHttpBody(), (Map)ParameterUtils.convert((Map)paramsMap));
        this.addRequestParams(builder, httpPropertyList, httpBody);
        String requestUrl = ParameterUtils.convertParameterPlaceholders((String)this.httpParameters.getUrl(), (Map)ParameterUtils.convert((Map)paramsMap));
        HttpUriRequest request = builder.setUri(requestUrl).build();
        this.setHeaders(request, httpPropertyList);
        return client.execute(request);
    }

    protected String getResponseBody(CloseableHttpResponse httpResponse) throws ParseException, IOException {
        if (httpResponse == null) {
            return null;
        }
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            return null;
        }
        return EntityUtils.toString((HttpEntity)entity, (String)StandardCharsets.UTF_8.name());
    }

    protected int getStatusCode(CloseableHttpResponse httpResponse) {
        return httpResponse.getStatusLine().getStatusCode();
    }

    protected int validResponse(String body, String statusCode) {
        int exitStatusCode = 0;
        switch (this.httpParameters.getHttpCheckCondition()) {
            case BODY_CONTAINS: {
                if (!StringUtils.isEmpty((CharSequence)body) && body.contains(this.httpParameters.getCondition())) break;
                this.appendMessage(this.httpParameters.getUrl() + " doesn contain " + this.httpParameters.getCondition());
                exitStatusCode = -1;
                break;
            }
            case BODY_NOT_CONTAINS: {
                if (!StringUtils.isEmpty((CharSequence)body) && !body.contains(this.httpParameters.getCondition())) break;
                this.appendMessage(this.httpParameters.getUrl() + " contains " + this.httpParameters.getCondition());
                exitStatusCode = -1;
                break;
            }
            case STATUS_CODE_CUSTOM: {
                if (statusCode.equals(this.httpParameters.getCondition())) break;
                this.appendMessage(this.httpParameters.getUrl() + " statuscode: " + statusCode + ", Must be: " + this.httpParameters.getCondition());
                exitStatusCode = -1;
                break;
            }
            default: {
                if ("200".equals(statusCode)) break;
                this.appendMessage(this.httpParameters.getUrl() + " statuscode: " + statusCode + ", Must be: 200");
                exitStatusCode = -1;
            }
        }
        return exitStatusCode;
    }

    public String getOutput() {
        return this.output;
    }

    protected void appendMessage(String message) {
        if (this.output == null) {
            this.output = "";
        }
        if (message != null && !message.trim().isEmpty()) {
            this.output = this.output + message;
        }
    }

    protected void addRequestParams(RequestBuilder builder, List<HttpProperty> httpPropertyList, String httpBody) {
        if (StringUtils.isNotEmpty((CharSequence)httpBody)) {
            builder.setEntity((HttpEntity)new StringEntity(httpBody, ContentType.create((String)ContentType.APPLICATION_JSON.getMimeType(), (Charset)StandardCharsets.UTF_8)));
        }
        if (CollectionUtils.isNotEmpty(httpPropertyList)) {
            ObjectNode jsonParam = JSONUtils.createObjectNode();
            for (HttpProperty property : httpPropertyList) {
                if (property.getHttpParametersType() == null) continue;
                if (property.getHttpParametersType().equals((Object)HttpParametersType.PARAMETER)) {
                    builder.addParameter(property.getProp(), property.getValue());
                    continue;
                }
                if (!property.getHttpParametersType().equals((Object)HttpParametersType.BODY)) continue;
                jsonParam.put(property.getProp(), property.getValue());
            }
            if (builder.getEntity() == null) {
                builder.setEntity((HttpEntity)new StringEntity(jsonParam.toString(), ContentType.create((String)ContentType.APPLICATION_JSON.getMimeType(), (Charset)StandardCharsets.UTF_8)));
            }
        }
    }

    protected void setHeaders(HttpUriRequest request, List<HttpProperty> httpPropertyList) {
        if (CollectionUtils.isNotEmpty(httpPropertyList)) {
            for (HttpProperty property : httpPropertyList) {
                if (!HttpParametersType.HEADERS.equals((Object)property.getHttpParametersType())) continue;
                request.addHeader(property.getProp(), property.getValue());
            }
        }
    }

    protected CloseableHttpClient createHttpClient() {
        RequestConfig requestConfig = this.requestConfig();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(requestConfig);
        return httpClientBuilder.build();
    }

    private RequestConfig requestConfig() {
        return RequestConfig.custom().setSocketTimeout(this.httpParameters.getSocketTimeout()).setConnectTimeout(this.httpParameters.getConnectTimeout()).build();
    }

    protected RequestBuilder createRequestBuilder() {
        if (this.httpParameters.getHttpMethod().equals((Object)HttpMethod.GET)) {
            return RequestBuilder.get();
        }
        if (this.httpParameters.getHttpMethod().equals((Object)HttpMethod.POST)) {
            return RequestBuilder.post();
        }
        if (this.httpParameters.getHttpMethod().equals((Object)HttpMethod.HEAD)) {
            return RequestBuilder.head();
        }
        if (this.httpParameters.getHttpMethod().equals((Object)HttpMethod.PUT)) {
            return RequestBuilder.put();
        }
        if (this.httpParameters.getHttpMethod().equals((Object)HttpMethod.DELETE)) {
            return RequestBuilder.delete();
        }
        return null;
    }

    public AbstractParameters getParameters() {
        return this.httpParameters;
    }

    public void addDefaultOutput(String response) {
        Property outputProperty = new Property();
        outputProperty.setProp(String.format("%s.%s", this.taskExecutionContext.getTaskName(), "response"));
        outputProperty.setDirect(Direct.OUT);
        outputProperty.setType(DataType.VARCHAR);
        outputProperty.setValue(response);
        this.httpParameters.addPropertyToValPool(outputProperty);
    }
}

