/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.java;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.ShellCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.resource.ResourceContext;
import org.apache.dolphinscheduler.plugin.task.api.shell.IShellInterceptorBuilder;
import org.apache.dolphinscheduler.plugin.task.api.shell.ShellInterceptorBuilderFactory;
import org.apache.dolphinscheduler.plugin.task.api.utils.MapUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.java.JavaConstants;
import org.apache.dolphinscheduler.plugin.task.java.JavaParameters;
import org.apache.dolphinscheduler.plugin.task.java.exception.JavaSourceFileExistException;
import org.apache.dolphinscheduler.plugin.task.java.exception.PublicClassNotFoundException;
import org.apache.dolphinscheduler.plugin.task.java.exception.RunTypeNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaTask
extends AbstractTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JavaTask.class);
    private JavaParameters javaParameters;
    private ShellCommandExecutor shellCommandExecutor;
    private TaskExecutionContext taskRequest;
    private static final Pattern classNamePattern = Pattern.compile("(.*\\s*public\\s+class\\s+)([a-zA-Z_]+[//w_]*)([.\\s\\S]*)");

    public JavaTask(TaskExecutionContext taskRequest) {
        super(taskRequest);
        this.taskRequest = taskRequest;
        this.shellCommandExecutor = new ShellCommandExecutor(arg_0 -> ((JavaTask)this).logHandle(arg_0), taskRequest);
    }

    public void init() {
        this.javaParameters = (JavaParameters)((Object)JSONUtils.parseObject((String)this.taskRequest.getTaskParams(), JavaParameters.class));
        if (this.javaParameters == null || !this.javaParameters.checkParameters()) {
            throw new TaskException("java task params is not valid");
        }
        log.info("Initialize java task params {}", (Object)JSONUtils.toPrettyJsonString((Object)((Object)this.javaParameters)));
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        try {
            String command = null;
            switch (this.javaParameters.getRunType()) {
                case "JAVA": {
                    command = this.buildJavaCommand();
                    break;
                }
                case "JAR": {
                    command = this.buildJarCommand();
                    break;
                }
                default: {
                    throw new RunTypeNotFoundException("run type is required, but it is null now.");
                }
            }
            Preconditions.checkNotNull((Object)command, (Object)"command not be null.");
            IShellInterceptorBuilder shellActuatorBuilder = ShellInterceptorBuilderFactory.newBuilder().appendScript(command);
            TaskResponse taskResponse = this.shellCommandExecutor.run(shellActuatorBuilder, taskCallBack);
            log.info("java task run result: {}", (Object)taskResponse);
            this.setExitStatusCode(taskResponse.getExitStatusCode());
            this.setAppIds(taskResponse.getAppIds());
            this.setProcessId(taskResponse.getProcessId());
            this.setTaskOutputParams(this.shellCommandExecutor.getTaskOutputParams());
        }
        catch (InterruptedException e) {
            log.error("java task interrupted ", (Throwable)e);
            this.setExitStatusCode(-1);
            Thread.currentThread().interrupt();
        }
        catch (RunTypeNotFoundException e) {
            log.error(e.getMessage());
            this.setExitStatusCode(-1);
            throw e;
        }
        catch (Exception e) {
            log.error("java task failed ", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("run java task error", (Throwable)e);
        }
    }

    protected String buildJavaCommand() throws Exception {
        StringBuilder builder = new StringBuilder();
        String sourceCode = this.buildJavaSourceContent();
        builder.append(this.buildJavaCompileCommand(sourceCode)).append(";").append(this.getJavaCommandPath()).append("java").append(" ").append(this.buildResourcePath()).append(" ").append(this.getPublicClassName(sourceCode)).append(" ").append(this.javaParameters.getMainArgs().trim()).append(" ").append(this.javaParameters.getJvmArgs().trim());
        return builder.toString();
    }

    protected String buildJarCommand() {
        ResourceContext resourceContext = this.taskRequest.getResourceContext();
        String mainJarName = resourceContext.getResourceItem(this.javaParameters.getMainJar().getResourceName()).getResourceAbsolutePathInLocal();
        StringBuilder builder = new StringBuilder();
        builder.append(this.getJavaCommandPath()).append("java").append(" ").append(this.buildResourcePath()).append(" ").append("-jar").append(" ").append(this.taskRequest.getExecutePath()).append("/").append(mainJarName).append(" ").append(this.javaParameters.getMainArgs().trim()).append(" ").append(this.javaParameters.getJvmArgs().trim());
        return builder.toString();
    }

    public void cancel() throws TaskException {
        try {
            this.shellCommandExecutor.cancelApplication();
        }
        catch (Exception e) {
            throw new TaskException();
        }
    }

    public AbstractParameters getParameters() {
        return this.javaParameters;
    }

    protected static String convertJavaSourceCodePlaceholders(String rawScript) throws StringIndexOutOfBoundsException {
        int len = "${setShareVar(${".length();
        int scriptStart = 0;
        while ((scriptStart = rawScript.indexOf("${setShareVar(${", scriptStart)) != -1) {
            int start = -1;
            int end = rawScript.indexOf(125, scriptStart + len);
            String prop = rawScript.substring(scriptStart + len, end);
            start = rawScript.indexOf(44, end);
            end = rawScript.indexOf(41, start);
            String value = rawScript.substring(start + 1, end);
            start = rawScript.indexOf(125, start) + 1;
            end = rawScript.length();
            String replaceScript = String.format("print(\"${{setValue({},{})}}\".format(\"%s\",%s))", prop, value);
            rawScript = rawScript.substring(0, scriptStart) + replaceScript + rawScript.substring(start, end);
            scriptStart += replaceScript.length();
        }
        return rawScript;
    }

    protected void createJavaSourceFileIfNotExists(String sourceCode, String fileName) throws IOException {
        log.info("tenantCode: {}, task dir:{}", (Object)this.taskRequest.getTenantCode(), (Object)this.taskRequest.getExecutePath());
        if (Files.exists(Paths.get(fileName, new String[0]), new LinkOption[0])) {
            throw new JavaSourceFileExistException("java source file exists, please report an issue on official.");
        }
        log.info("the java source code:{}, will be write to the file: {}", (Object)fileName, (Object)sourceCode);
        FileUtils.writeStringToFile((File)new File(fileName), (String)sourceCode, (Charset)StandardCharsets.UTF_8);
    }

    protected String buildJavaSourceCodeFileFullName(String publicClassName) {
        return String.format("%s/%s.java", this.taskRequest.getExecutePath(), publicClassName);
    }

    protected String buildResourcePath() {
        StringBuilder builder = new StringBuilder();
        if (this.javaParameters.isModulePath()) {
            builder.append("--module-path");
        } else {
            builder.append("-classpath");
        }
        builder.append(" ").append(".").append(JavaConstants.PATH_SEPARATOR).append(this.taskRequest.getExecutePath());
        ResourceContext resourceContext = this.taskRequest.getResourceContext();
        for (ResourceInfo info : this.javaParameters.getResourceFilesList()) {
            builder.append(JavaConstants.PATH_SEPARATOR);
            builder.append(this.taskRequest.getExecutePath()).append("/").append(resourceContext.getResourceItem(info.getResourceName()).getResourceAbsolutePathInLocal());
        }
        return builder.toString();
    }

    protected String buildJavaCompileCommand(String sourceCode) throws IOException {
        String publicClassName = this.getPublicClassName(sourceCode);
        String fileName = this.buildJavaSourceCodeFileFullName(publicClassName);
        this.createJavaSourceFileIfNotExists(sourceCode, fileName);
        StringBuilder compilerCommand = new StringBuilder().append(this.getJavaCommandPath()).append("javac").append(" ").append(this.buildResourcePath()).append(" ").append(fileName);
        return compilerCommand.toString();
    }

    protected String buildJavaSourceContent() {
        String rawJavaScript = this.javaParameters.getRawScript().replaceAll("\\r\\n", "\n");
        HashMap paramsMap = this.taskRequest.getPrepareParamsMap();
        if (MapUtils.isEmpty((Map)paramsMap)) {
            paramsMap = new HashMap();
        }
        if (MapUtils.isNotEmpty((Map)this.taskRequest.getParamsMap())) {
            paramsMap.putAll(this.taskRequest.getParamsMap());
        }
        log.info("The current java source code will begin to replace the placeholder: {}", (Object)rawJavaScript);
        rawJavaScript = ParameterUtils.convertParameterPlaceholders((String)rawJavaScript, (Map)ParameterUtils.convert(paramsMap));
        return rawJavaScript;
    }

    private String getJavaCommandPath() {
        return "${JAVA_HOME}" + File.separator + "bin" + File.separator;
    }

    public String getPublicClassName(String sourceCode) {
        Matcher matcher = classNamePattern.matcher(sourceCode);
        if (!matcher.find()) {
            throw new PublicClassNotFoundException("public class is not be found in source code : " + sourceCode);
        }
        return matcher.group(2).trim();
    }
}

