/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.procedure;

import com.google.common.collect.Maps;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.DataType;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.procedure.ProcedureParameters;
import org.apache.dolphinscheduler.plugin.task.procedure.ProcedureTaskExecutionContext;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

public class ProcedureTask
extends AbstractTask {
    private ProcedureParameters procedureParameters;
    private TaskExecutionContext taskExecutionContext;
    private ProcedureTaskExecutionContext procedureTaskExecutionContext;

    public ProcedureTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
        this.logger.info("procedure task params {}", (Object)taskExecutionContext.getTaskParams());
        this.procedureParameters = (ProcedureParameters)((Object)JSONUtils.parseObject((String)taskExecutionContext.getTaskParams(), ProcedureParameters.class));
        if (!this.procedureParameters.checkParameters()) {
            throw new RuntimeException("procedure task params is not valid");
        }
        this.procedureTaskExecutionContext = this.procedureParameters.generateExtendedContext(taskExecutionContext.getResourceParametersHelper());
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        this.logger.info("procedure type : {}, datasource : {}, method : {} , localParams : {}", new Object[]{this.procedureParameters.getType(), this.procedureParameters.getDatasource(), this.procedureParameters.getMethod(), this.procedureParameters.getLocalParams()});
        Connection connection = null;
        CallableStatement stmt = null;
        try {
            HashMap paramsMap;
            DbType dbType = DbType.valueOf((String)this.procedureParameters.getType());
            ConnectionParam connectionParam = DataSourceUtils.buildConnectionParams((DbType)DbType.valueOf((String)this.procedureParameters.getType()), (String)this.procedureTaskExecutionContext.getConnectionParams());
            connection = DataSourceUtils.getConnection((DbType)dbType, (ConnectionParam)connectionParam);
            HashMap<Integer, Property> sqlParamsMap = new HashMap<Integer, Property>();
            Map map = paramsMap = this.taskExecutionContext.getPrepareParamsMap() == null ? Maps.newHashMap() : this.taskExecutionContext.getPrepareParamsMap();
            if (this.procedureParameters.getOutProperty() != null) {
                paramsMap.putAll(this.procedureParameters.getOutProperty());
            }
            String proceduerSql = this.formatSql(sqlParamsMap, paramsMap);
            stmt = connection.prepareCall(proceduerSql);
            this.setTimeout(stmt);
            Map<Integer, Property> outParameterMap = this.getOutParameterMap(stmt, sqlParamsMap, paramsMap);
            stmt.executeUpdate();
            this.printOutParameter(stmt, outParameterMap);
            this.setExitStatusCode(0);
            this.close(stmt, connection);
        }
        catch (Exception e) {
            try {
                this.setExitStatusCode(-1);
                this.logger.error("procedure task error", (Throwable)e);
                throw new TaskException("Execute procedure task failed", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(stmt, connection);
                throw throwable;
            }
        }
    }

    public void cancel() throws TaskException {
    }

    private String formatSql(Map<Integer, Property> sqlParamsMap, Map<String, Property> paramsMap) {
        this.setSqlParamsMap(this.procedureParameters.getMethod(), this.rgex, sqlParamsMap, paramsMap, this.taskExecutionContext.getTaskInstanceId());
        return this.procedureParameters.getMethod().replaceAll(this.rgex, "?");
    }

    private void printOutParameter(CallableStatement stmt, Map<Integer, Property> outParameterMap) throws SQLException {
        for (Map.Entry<Integer, Property> en : outParameterMap.entrySet()) {
            int index = en.getKey();
            Property property = en.getValue();
            String prop = property.getProp();
            DataType dataType = property.getType();
            this.procedureParameters.dealOutParam4Procedure(this.getOutputParameter(stmt, index, prop, dataType), prop);
        }
    }

    private Map<Integer, Property> getOutParameterMap(CallableStatement stmt, Map<Integer, Property> paramsMap, Map<String, Property> totalParamsMap) throws Exception {
        HashMap<Integer, Property> outParameterMap = new HashMap<Integer, Property>();
        if (this.procedureParameters.getLocalParametersMap() == null) {
            return outParameterMap;
        }
        int index = 1;
        if (paramsMap != null) {
            for (Map.Entry<Integer, Property> entry : paramsMap.entrySet()) {
                Property property = entry.getValue();
                if (property.getDirect().equals((Object)Direct.IN)) {
                    ParameterUtils.setInParameter((int)index, (PreparedStatement)stmt, (DataType)property.getType(), (String)totalParamsMap.get(property.getProp()).getValue());
                } else if (property.getDirect().equals((Object)Direct.OUT)) {
                    this.setOutParameter(index, stmt, property.getType(), totalParamsMap.get(property.getProp()).getValue());
                    outParameterMap.put(index, property);
                }
                ++index;
            }
        }
        return outParameterMap;
    }

    private void setTimeout(CallableStatement stmt) throws SQLException {
        Boolean failed = this.taskExecutionContext.getTaskTimeoutStrategy() == TaskTimeoutStrategy.FAILED;
        Boolean warnFailed = this.taskExecutionContext.getTaskTimeoutStrategy() == TaskTimeoutStrategy.WARNFAILED;
        if (failed.booleanValue() || warnFailed.booleanValue()) {
            stmt.setQueryTimeout(this.taskExecutionContext.getTaskTimeout());
        }
    }

    private void close(PreparedStatement stmt, Connection connection) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                this.logger.error("close prepared statement error : {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                this.logger.error("close connection error : {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private Object getOutputParameter(CallableStatement stmt, int index, String prop, DataType dataType) throws SQLException {
        Object value = null;
        switch (dataType) {
            case VARCHAR: {
                this.logger.info("out prameter varchar key : {} , value : {}", (Object)prop, (Object)stmt.getString(index));
                value = stmt.getString(index);
                break;
            }
            case INTEGER: {
                this.logger.info("out prameter integer key : {} , value : {}", (Object)prop, (Object)stmt.getInt(index));
                value = stmt.getInt(index);
                break;
            }
            case LONG: {
                this.logger.info("out prameter long key : {} , value : {}", (Object)prop, (Object)stmt.getLong(index));
                value = stmt.getLong(index);
                break;
            }
            case FLOAT: {
                this.logger.info("out prameter float key : {} , value : {}", (Object)prop, (Object)Float.valueOf(stmt.getFloat(index)));
                value = Float.valueOf(stmt.getFloat(index));
                break;
            }
            case DOUBLE: {
                this.logger.info("out prameter double key : {} , value : {}", (Object)prop, (Object)stmt.getDouble(index));
                value = stmt.getDouble(index);
                break;
            }
            case DATE: {
                this.logger.info("out prameter date key : {} , value : {}", (Object)prop, (Object)stmt.getDate(index));
                value = stmt.getDate(index);
                break;
            }
            case TIME: {
                this.logger.info("out prameter time key : {} , value : {}", (Object)prop, (Object)stmt.getTime(index));
                value = stmt.getTime(index);
                break;
            }
            case TIMESTAMP: {
                this.logger.info("out prameter timestamp key : {} , value : {}", (Object)prop, (Object)stmt.getTimestamp(index));
                value = stmt.getTimestamp(index);
                break;
            }
            case BOOLEAN: {
                this.logger.info("out prameter boolean key : {} , value : {}", (Object)prop, (Object)stmt.getBoolean(index));
                value = stmt.getBoolean(index);
                break;
            }
        }
        return value;
    }

    public AbstractParameters getParameters() {
        return this.procedureParameters;
    }

    private void setOutParameter(int index, CallableStatement stmt, DataType dataType, String value) throws Exception {
        int sqlType;
        switch (dataType) {
            case VARCHAR: {
                sqlType = 12;
                break;
            }
            case INTEGER: 
            case LONG: {
                sqlType = 4;
                break;
            }
            case FLOAT: {
                sqlType = 6;
                break;
            }
            case DOUBLE: {
                sqlType = 8;
                break;
            }
            case DATE: {
                sqlType = 91;
                break;
            }
            case TIME: {
                sqlType = 92;
                break;
            }
            case TIMESTAMP: {
                sqlType = 93;
                break;
            }
            case BOOLEAN: {
                sqlType = 16;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + dataType);
            }
        }
        if (StringUtils.isEmpty((CharSequence)value)) {
            stmt.registerOutParameter(index, sqlType);
        } else {
            stmt.registerOutParameter(index, sqlType, value);
        }
    }
}

