/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.seatunnel;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.ShellCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParamUtils;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.seatunnel.SeatunnelParameters;

public class SeatunnelTask
extends AbstractRemoteTask {
    private static final String SEATUNNEL_BIN_DIR = "${SEATUNNEL_HOME}/bin/";
    private SeatunnelParameters seatunnelParameters;
    private ShellCommandExecutor shellCommandExecutor;
    protected final TaskExecutionContext taskExecutionContext;

    public SeatunnelTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
        this.shellCommandExecutor = new ShellCommandExecutor(arg_0 -> ((SeatunnelTask)this).logHandle(arg_0), taskExecutionContext, this.logger);
    }

    public List<String> getApplicationIds() throws TaskException {
        return Collections.emptyList();
    }

    public void init() {
        this.logger.info("SeaTunnel task params {}", (Object)this.taskExecutionContext.getTaskParams());
        if (!this.seatunnelParameters.checkParameters()) {
            throw new RuntimeException("SeaTunnel task params is not valid");
        }
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        try {
            String command = this.buildCommand();
            TaskResponse commandExecuteResult = this.shellCommandExecutor.run(command);
            this.setExitStatusCode(commandExecuteResult.getExitStatusCode());
            this.setAppIds(String.join((CharSequence)",", this.getApplicationIds()));
            this.setProcessId(commandExecuteResult.getProcessId());
            this.seatunnelParameters.dealOutParam(this.shellCommandExecutor.getVarPool());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.error("The current SeaTunnel task has been interrupted", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("The current SeaTunnel task has been interrupted", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("SeaTunnel task error", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("Execute Seatunnel task failed", (Throwable)e);
        }
    }

    public void submitApplication() throws TaskException {
    }

    public void trackApplicationStatus() throws TaskException {
    }

    public void cancelApplication() throws TaskException {
        try {
            this.shellCommandExecutor.cancelApplication();
        }
        catch (Exception e) {
            throw new TaskException("cancel application error", (Throwable)e);
        }
    }

    private String buildCommand() throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.add(SEATUNNEL_BIN_DIR + this.seatunnelParameters.getStartupScript());
        args.addAll(this.buildOptions());
        String command = String.join((CharSequence)" ", args);
        this.logger.info("SeaTunnel task command: {}", (Object)command);
        return command;
    }

    protected List<String> buildOptions() throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        if (BooleanUtils.isTrue((Boolean)this.seatunnelParameters.getUseCustom())) {
            args.add("--config");
            args.add(this.buildCustomConfigCommand());
        } else {
            this.seatunnelParameters.getResourceList().forEach(resourceInfo -> {
                args.add("--config");
                args.add(resourceInfo.getResourceName().substring(1));
            });
        }
        return args;
    }

    protected String buildCustomConfigCommand() throws Exception {
        String config = this.buildCustomConfigContent();
        String filePath = this.buildConfigFilePath();
        this.createConfigFileIfNotExists(config, filePath);
        return filePath;
    }

    private String buildCustomConfigContent() {
        this.logger.info("raw custom config content : {}", (Object)this.seatunnelParameters.getRawScript());
        String script = this.seatunnelParameters.getRawScript().replaceAll("\\r\\n", "\n");
        script = this.parseScript(script);
        return script;
    }

    private String buildConfigFilePath() {
        return String.format("%s/seatunnel_%s.conf", this.taskExecutionContext.getExecutePath(), this.taskExecutionContext.getTaskAppId());
    }

    private void createConfigFileIfNotExists(String script, String scriptFile) throws IOException {
        this.logger.info("tenantCode :{}, task dir:{}", (Object)this.taskExecutionContext.getTenantCode(), (Object)this.taskExecutionContext.getExecutePath());
        if (!Files.exists(Paths.get(scriptFile, new String[0]), new LinkOption[0])) {
            this.logger.info("generate script file:{}", (Object)scriptFile);
            FileUtils.writeStringToFile((File)new File(scriptFile), (String)script, (Charset)StandardCharsets.UTF_8);
        }
    }

    public AbstractParameters getParameters() {
        return this.seatunnelParameters;
    }

    private String parseScript(String script) {
        Map paramsMap = this.taskExecutionContext.getPrepareParamsMap();
        return ParameterUtils.convertParameterPlaceholders((String)script, (Map)ParamUtils.convert((Map)paramsMap));
    }

    public void setSeatunnelParameters(SeatunnelParameters seatunnelParameters) {
        this.seatunnelParameters = seatunnelParameters;
    }
}

