/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop.generator.targets;

import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.ITargetGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.SqoopParameters;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.targets.TargetHanaParameter;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HanaTargetGenerator
implements ITargetGenerator {
    private static final Logger logger = LoggerFactory.getLogger(HanaTargetGenerator.class);

    @Override
    public String generate(SqoopParameters sqoopParameters, SqoopTaskExecutionContext sqoopTaskExecutionContext) {
        StringBuilder hanaTargetSb = new StringBuilder();
        try {
            TargetHanaParameter targetHanaParameter = (TargetHanaParameter)JSONUtils.parseObject((String)sqoopParameters.getTargetParams(), TargetHanaParameter.class);
            if (null == targetHanaParameter || targetHanaParameter.getTargetDatasource() == 0) {
                return hanaTargetSb.toString();
            }
            BaseConnectionParam baseDataSource = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)sqoopTaskExecutionContext.getTargetType(), (String)sqoopTaskExecutionContext.getTargetConnectionParams());
            if (null == baseDataSource) {
                return hanaTargetSb.toString();
            }
            hanaTargetSb.append(" ").append("--connect").append(" ").append("\"").append(DataSourceUtils.getJdbcUrl((DbType)DbType.HANA, (ConnectionParam)baseDataSource)).append("\"").append(" ").append("--driver").append(" ").append(DataSourceUtils.getDatasourceDriver((DbType)DbType.HANA)).append(" ").append("--username").append(" ").append(baseDataSource.getUser()).append(" ").append("--password").append(" ").append("\"").append(PasswordUtils.decodePassword((String)baseDataSource.getPassword())).append("\"").append(" ").append("--table").append(" ").append(targetHanaParameter.getTargetTable());
            if (StringUtils.isNotEmpty((CharSequence)targetHanaParameter.getTargetColumns())) {
                hanaTargetSb.append(" ").append("--columns").append(" ").append(targetHanaParameter.getTargetColumns());
            }
            if (StringUtils.isNotEmpty((CharSequence)targetHanaParameter.getFieldsTerminated())) {
                hanaTargetSb.append(" ").append("--fields-terminated-by");
                if (targetHanaParameter.getFieldsTerminated().contains("'")) {
                    hanaTargetSb.append(" ").append(targetHanaParameter.getFieldsTerminated());
                } else {
                    hanaTargetSb.append(" ").append("'").append(targetHanaParameter.getFieldsTerminated()).append("'");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)targetHanaParameter.getLinesTerminated())) {
                hanaTargetSb.append(" ").append("--lines-terminated-by");
                if (targetHanaParameter.getLinesTerminated().contains("'")) {
                    hanaTargetSb.append(" ").append(targetHanaParameter.getLinesTerminated());
                } else {
                    hanaTargetSb.append(" ").append("'").append(targetHanaParameter.getLinesTerminated()).append("'");
                }
            }
            if (targetHanaParameter.getIsUpdate() && StringUtils.isNotEmpty((CharSequence)targetHanaParameter.getTargetUpdateKey()) && StringUtils.isNotEmpty((CharSequence)targetHanaParameter.getTargetUpdateMode())) {
                hanaTargetSb.append(" ").append("--update-key").append(" ").append(targetHanaParameter.getTargetUpdateKey()).append(" ").append("--update-mode").append(" ").append(targetHanaParameter.getTargetUpdateMode());
            }
        }
        catch (Exception e) {
            logger.error(String.format("Sqoop hana target params build failed: [%s]", e.getMessage()));
        }
        return hanaTargetSb.toString();
    }
}

