/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop.generator.targets;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.ITargetGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.SqoopParameters;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.targets.TargetHdfsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsTargetGenerator
implements ITargetGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HdfsTargetGenerator.class);

    @Override
    public String generate(SqoopParameters sqoopParameters, SqoopTaskExecutionContext sqoopTaskExecutionContext) {
        StringBuilder hdfsTargetSb = new StringBuilder();
        try {
            TargetHdfsParameter targetHdfsParameter = (TargetHdfsParameter)JSONUtils.parseObject((String)sqoopParameters.getTargetParams(), TargetHdfsParameter.class);
            if (null != targetHdfsParameter) {
                if (StringUtils.isNotEmpty((CharSequence)targetHdfsParameter.getTargetPath())) {
                    hdfsTargetSb.append(" ").append("--target-dir").append(" ").append(targetHdfsParameter.getTargetPath());
                }
                if (StringUtils.isNotEmpty((CharSequence)targetHdfsParameter.getCompressionCodec())) {
                    hdfsTargetSb.append(" ").append("--compression-codec").append(" ").append(targetHdfsParameter.getCompressionCodec());
                }
                if (StringUtils.isNotEmpty((CharSequence)targetHdfsParameter.getFileType())) {
                    hdfsTargetSb.append(" ").append(targetHdfsParameter.getFileType());
                }
                if (targetHdfsParameter.isDeleteTargetDir()) {
                    hdfsTargetSb.append(" ").append("--delete-target-dir");
                }
                if (StringUtils.isNotEmpty((CharSequence)targetHdfsParameter.getFieldsTerminated())) {
                    hdfsTargetSb.append(" ").append("--fields-terminated-by").append(" ").append("'").append(targetHdfsParameter.getFieldsTerminated()).append("'");
                }
                if (StringUtils.isNotEmpty((CharSequence)targetHdfsParameter.getLinesTerminated())) {
                    hdfsTargetSb.append(" ").append("--lines-terminated-by").append(" ").append("'").append(targetHdfsParameter.getLinesTerminated()).append("'");
                }
                hdfsTargetSb.append(" ").append("--null-non-string 'NULL' --null-string 'NULL'");
            }
        }
        catch (Exception e) {
            log.error(String.format("Sqoop hdfs target params build failed: [%s]", e.getMessage()));
        }
        return hdfsTargetSb.toString();
    }
}

