/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop.generator.targets;

import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.ITargetGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.SqoopParameters;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.targets.TargetOracleParameter;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleTargetGenerator
implements ITargetGenerator {
    private static final Logger logger = LoggerFactory.getLogger(OracleTargetGenerator.class);

    @Override
    public String generate(SqoopParameters sqoopParameters, SqoopTaskExecutionContext sqoopTaskExecutionContext) {
        StringBuilder oracleTargetSb = new StringBuilder();
        try {
            TargetOracleParameter targetOracleParameter = (TargetOracleParameter)JSONUtils.parseObject((String)sqoopParameters.getTargetParams(), TargetOracleParameter.class);
            if (null == targetOracleParameter || targetOracleParameter.getTargetDatasource() == 0) {
                return oracleTargetSb.toString();
            }
            BaseConnectionParam baseDataSource = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)sqoopTaskExecutionContext.getTargetType(), (String)sqoopTaskExecutionContext.getTargetConnectionParams());
            if (null == baseDataSource) {
                return oracleTargetSb.toString();
            }
            oracleTargetSb.append(" ").append("--connect").append(" ").append("\"").append(DataSourceUtils.getJdbcUrl((DbType)DbType.ORACLE, (ConnectionParam)baseDataSource)).append("\"").append(" ").append("--username").append(" ").append(baseDataSource.getUser()).append(" ").append("--password").append(" ").append("\"").append(PasswordUtils.decodePassword((String)baseDataSource.getPassword())).append("\"").append(" ").append("--table").append(" ").append(targetOracleParameter.getTargetTable());
            if (StringUtils.isNotEmpty((CharSequence)targetOracleParameter.getTargetColumns())) {
                oracleTargetSb.append(" ").append("--columns").append(" ").append(targetOracleParameter.getTargetColumns());
            }
            if (StringUtils.isNotEmpty((CharSequence)targetOracleParameter.getFieldsTerminated())) {
                oracleTargetSb.append(" ").append("--fields-terminated-by");
                if (targetOracleParameter.getFieldsTerminated().contains("'")) {
                    oracleTargetSb.append(" ").append(targetOracleParameter.getFieldsTerminated());
                } else {
                    oracleTargetSb.append(" ").append("'").append(targetOracleParameter.getFieldsTerminated()).append("'");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)targetOracleParameter.getLinesTerminated())) {
                oracleTargetSb.append(" ").append("--lines-terminated-by");
                if (targetOracleParameter.getLinesTerminated().contains("'")) {
                    oracleTargetSb.append(" ").append(targetOracleParameter.getLinesTerminated());
                } else {
                    oracleTargetSb.append(" ").append("'").append(targetOracleParameter.getLinesTerminated()).append("'");
                }
            }
            if (targetOracleParameter.getIsUpdate() && StringUtils.isNotEmpty((CharSequence)targetOracleParameter.getTargetUpdateKey()) && StringUtils.isNotEmpty((CharSequence)targetOracleParameter.getTargetUpdateMode())) {
                oracleTargetSb.append(" ").append("--update-key").append(" ").append(targetOracleParameter.getTargetUpdateKey()).append(" ").append("--update-mode").append(" ").append(targetOracleParameter.getTargetUpdateMode());
            }
        }
        catch (Exception e) {
            logger.error(String.format("Sqoop oracle target params build failed: [%s]", e.getMessage()));
        }
        return oracleTargetSb.toString();
    }
}

