/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.zeppelin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.Unirest;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.zeppelin.ZeppelinParameters;
import org.apache.dolphinscheduler.plugin.task.zeppelin.ZeppelinTaskException;
import org.apache.zeppelin.client.ClientConfig;
import org.apache.zeppelin.client.NoteResult;
import org.apache.zeppelin.client.ParagraphResult;
import org.apache.zeppelin.client.Status;
import org.apache.zeppelin.client.ZeppelinClient;

public class ZeppelinTask
extends AbstractRemoteTask {
    private final TaskExecutionContext taskExecutionContext;
    private ZeppelinParameters zeppelinParameters;
    private ZeppelinClient zClient;

    protected ZeppelinTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() {
        String taskParams = this.taskExecutionContext.getTaskParams();
        this.logger.info("zeppelin task params:{}", (Object)taskParams);
        this.zeppelinParameters = (ZeppelinParameters)((Object)JSONUtils.parseObject((String)taskParams, ZeppelinParameters.class));
        if (this.zeppelinParameters == null || !this.zeppelinParameters.checkParameters()) {
            throw new ZeppelinTaskException("zeppelin task params is not valid");
        }
        this.zClient = this.getZeppelinClient();
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        try {
            String resultContent;
            String paragraphId = this.zeppelinParameters.getParagraphId();
            String productionNoteDirectory = this.zeppelinParameters.getProductionNoteDirectory();
            String parameters = this.zeppelinParameters.getParameters();
            String noteId = this.zeppelinParameters.getNoteId();
            Map zeppelinParamsMap = new HashMap();
            if (parameters != null) {
                ObjectMapper mapper = new ObjectMapper();
                zeppelinParamsMap = (Map)mapper.readValue(parameters, Map.class);
            }
            Status status = Status.FINISHED;
            if (productionNoteDirectory != null) {
                String cloneNotePath = String.format("%s%s_%s", productionNoteDirectory, noteId, DateUtils.getTimestampString());
                noteId = this.zClient.cloneNote(noteId, cloneNotePath);
            }
            if (paragraphId == null) {
                NoteResult noteResult = this.zClient.executeNote(noteId, zeppelinParamsMap);
                List paragraphResultList = noteResult.getParagraphResultList();
                StringBuilder resultContentBuilder = new StringBuilder();
                for (ParagraphResult paragraphResult : paragraphResultList) {
                    resultContentBuilder.append(String.format("paragraph_id: %s, paragraph_result: %s\n", paragraphResult.getParagraphId(), paragraphResult.getResultInText()));
                    status = paragraphResult.getStatus();
                    if (status == Status.FINISHED) continue;
                    break;
                }
                resultContent = resultContentBuilder.toString();
            } else {
                ParagraphResult paragraphResult = this.zClient.executeParagraph(noteId, paragraphId, zeppelinParamsMap);
                resultContent = paragraphResult.getResultInText();
                status = paragraphResult.getStatus();
            }
            if (productionNoteDirectory != null) {
                this.zClient.deleteNote(noteId);
            }
            int exitStatusCode = this.mapStatusToExitCode(status);
            this.setAppIds(String.format("%s-%s", noteId, paragraphId));
            this.setExitStatusCode(exitStatusCode);
            this.logger.info("zeppelin task finished with results: {}", (Object)resultContent);
        }
        catch (Exception e) {
            this.setExitStatusCode(-1);
            this.logger.error("zeppelin task submit failed with error", (Throwable)e);
            throw new TaskException("Execute ZeppelinTask exception");
        }
    }

    public void submitApplication() throws TaskException {
    }

    public void trackApplicationStatus() throws TaskException {
    }

    private ZeppelinClient getZeppelinClient() {
        String restEndpoint = this.zeppelinParameters.getRestEndpoint();
        ClientConfig clientConfig = new ClientConfig(restEndpoint);
        ZeppelinClient zClient = null;
        try {
            zClient = new ZeppelinClient(clientConfig);
            String zeppelinVersion = zClient.getVersion();
            this.logger.info("zeppelin version: {}", (Object)zeppelinVersion);
        }
        catch (Exception e) {
            this.logger.error("some error");
        }
        return zClient;
    }

    private int mapStatusToExitCode(Status status) {
        switch (status) {
            case FINISHED: {
                return 0;
            }
            case ABORT: {
                return 137;
            }
        }
        return -1;
    }

    public AbstractParameters getParameters() {
        return this.zeppelinParameters;
    }

    public void cancelApplication() throws TaskException {
        String restEndpoint = this.zeppelinParameters.getRestEndpoint();
        String noteId = this.zeppelinParameters.getNoteId();
        String paragraphId = this.zeppelinParameters.getParagraphId();
        if (paragraphId == null) {
            this.logger.info("trying terminate zeppelin task, taskId: {}, noteId: {}", (Object)this.taskExecutionContext.getTaskInstanceId(), (Object)noteId);
            Unirest.config().defaultBaseUrl(restEndpoint + "/api");
            ((HttpRequestWithBody)Unirest.delete((String)"/notebook/job/{noteId}").routeParam("noteId", noteId)).asJson();
            this.logger.info("zeppelin task terminated, taskId: {}, noteId: {}", (Object)this.taskExecutionContext.getTaskInstanceId(), (Object)noteId);
        } else {
            this.logger.info("trying terminate zeppelin task, taskId: {}, noteId: {}, paragraphId: {}", new Object[]{this.taskExecutionContext.getTaskInstanceId(), noteId, paragraphId});
            try {
                this.zClient.cancelParagraph(noteId, paragraphId);
            }
            catch (Exception e) {
                throw new TaskException("cancel paragraph error", (Throwable)e);
            }
            this.logger.info("zeppelin task terminated, taskId: {}, noteId: {}, paragraphId: {}", new Object[]{this.taskExecutionContext.getTaskInstanceId(), noteId, paragraphId});
        }
    }

    public List<String> getApplicationIds() throws TaskException {
        return Collections.emptyList();
    }
}

