/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.tools.datasource;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.dao.plugin.api.dialect.DatabaseDialect;
import org.apache.dolphinscheduler.tools.datasource.upgrader.DolphinSchedulerUpgrader;
import org.apache.dolphinscheduler.tools.datasource.upgrader.DolphinSchedulerVersion;
import org.apache.dolphinscheduler.tools.datasource.upgrader.UpgradeDao;
import org.apache.dolphinscheduler.tools.datasource.utils.SchemaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DolphinSchedulerManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DolphinSchedulerManager.class);
    @Autowired
    private UpgradeDao upgradeDao;
    @Autowired
    private DatabaseDialect databaseDialect;
    private Map<DolphinSchedulerVersion, DolphinSchedulerUpgrader> upgraderMap = new HashMap<DolphinSchedulerVersion, DolphinSchedulerUpgrader>();

    public DolphinSchedulerManager(List<DolphinSchedulerUpgrader> dolphinSchedulerUpgraders) throws Exception {
        if (CollectionUtils.isNotEmpty(dolphinSchedulerUpgraders)) {
            this.upgraderMap = dolphinSchedulerUpgraders.stream().collect(Collectors.toMap(DolphinSchedulerUpgrader::getCurrentVersion, Function.identity()));
        }
    }

    public void initDolphinScheduler() {
        this.initDolphinSchedulerSchema();
    }

    public boolean schemaIsInitialized() {
        if (this.databaseDialect.tableExists("t_escheduler_version") || this.databaseDialect.tableExists("t_ds_version") || this.databaseDialect.tableExists("t_escheduler_queue")) {
            log.info("The database has been initialized. Skip the initialization step");
            return true;
        }
        return false;
    }

    public void initDolphinSchedulerSchema() {
        log.info("Start initializing the DolphinScheduler manager table structure");
        this.upgradeDao.initSchema();
    }

    public void upgradeDolphinScheduler() throws IOException {
        List<String> schemaList = SchemaUtils.getAllSchemaList();
        if (schemaList == null || schemaList.size() == 0) {
            log.info("There is no schema to upgrade!");
        } else {
            String version;
            if (this.databaseDialect.tableExists("t_escheduler_version")) {
                version = this.upgradeDao.getCurrentVersion("t_escheduler_version");
            } else if (this.databaseDialect.tableExists("t_ds_version")) {
                version = this.upgradeDao.getCurrentVersion("t_ds_version");
            } else if (this.databaseDialect.columnExists("t_escheduler_queue", "create_time")) {
                version = "1.0.1";
            } else if (this.databaseDialect.tableExists("t_escheduler_queue")) {
                version = "1.0.0";
            } else {
                log.error("Unable to determine current software version, so cannot upgrade");
                throw new RuntimeException("Unable to determine current software version, so cannot upgrade");
            }
            String schemaVersion = "";
            String currentVersion = version;
            for (String schemaDir : schemaList) {
                schemaVersion = schemaDir.split("_")[0];
                if (!SchemaUtils.isAGreatVersion(schemaVersion, version)) continue;
                log.info("upgrade DolphinScheduler metadata version from {} to {}", (Object)version, (Object)schemaVersion);
                log.info("Begin upgrading DolphinScheduler's table structure");
                this.upgradeDao.upgradeDolphinScheduler(schemaDir);
                DolphinSchedulerVersion.getVersion(schemaVersion).ifPresent(v -> this.upgraderMap.get(v).doUpgrade());
                version = schemaVersion;
            }
            if (SchemaUtils.isAGreatVersion("2.0.6", currentVersion) && SchemaUtils.isAGreatVersion(SchemaUtils.getSoftVersion(), currentVersion)) {
                this.upgradeDao.upgradeDolphinSchedulerResourceFileSize();
            }
        }
        this.upgradeDao.updateVersion(SchemaUtils.getSoftVersion());
    }
}

