/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.tools.datasource;

import lombok.Generated;
import org.apache.dolphinscheduler.dao.DaoConfiguration;
import org.apache.dolphinscheduler.tools.datasource.DolphinSchedulerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@ImportAutoConfiguration(value={DaoConfiguration.class})
@SpringBootApplication
public class UpgradeDolphinScheduler {
    public static void main(String[] args) {
        SpringApplication.run(UpgradeDolphinScheduler.class, (String[])args);
    }

    @Component
    @Profile(value={"upgrade"})
    static class UpgradeRunner
    implements CommandLineRunner {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(UpgradeRunner.class);
        private final DolphinSchedulerManager dolphinSchedulerManager;

        UpgradeRunner(DolphinSchedulerManager dolphinSchedulerManager) {
            this.dolphinSchedulerManager = dolphinSchedulerManager;
        }

        public void run(String ... args) throws Exception {
            if (this.dolphinSchedulerManager.schemaIsInitialized()) {
                this.dolphinSchedulerManager.upgradeDolphinScheduler();
                log.info("upgrade DolphinScheduler finished");
            } else {
                this.dolphinSchedulerManager.initDolphinScheduler();
                log.info("init DolphinScheduler finished");
            }
        }
    }
}

