/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.tools.datasource.dao;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ResourceDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceDao.class);

    private Map<String, Long> listAllResourcesByFileType(Connection conn, int type) {
        HashMap<String, Long> resourceSizeMap = new HashMap<String, Long>();
        String sql = String.format("SELECT full_name, type, size, is_directory FROM t_ds_resources where type = %d", type);
        try (PreparedStatement pstmt = conn.prepareStatement(sql);
             ResultSet rs = pstmt.executeQuery();){
            while (rs.next()) {
                String fullName = rs.getString("full_name");
                boolean isDirectory = rs.getBoolean("is_directory");
                long fileSize = rs.getLong("size");
                if (!StringUtils.isNotBlank((CharSequence)fullName) || isDirectory) continue;
                String[] splits = fullName.split("/");
                for (int i = 1; i < splits.length; ++i) {
                    String parentFullName = Joiner.on((String)"/").join((Object[])Arrays.copyOfRange(splits, 0, splits.length - i));
                    if (Strings.isNullOrEmpty((String)parentFullName)) continue;
                    long size = resourceSizeMap.getOrDefault(parentFullName, 0L);
                    resourceSizeMap.put(parentFullName, size + fileSize);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("sql: " + sql, e);
        }
        return resourceSizeMap;
    }

    public void updateResourceFolderSizeByFileType(Connection conn, int type) {
        Map<String, Long> resourceSizeMap = this.listAllResourcesByFileType(conn, type);
        String sql = "UPDATE t_ds_resources SET size=? where type=? and full_name=? and is_directory = true";
        try (PreparedStatement pstmt = conn.prepareStatement(sql);){
            for (Map.Entry<String, Long> entry : resourceSizeMap.entrySet()) {
                pstmt.setLong(1, entry.getValue());
                pstmt.setInt(2, type);
                pstmt.setString(3, entry.getKey());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("sql: " + sql, e);
        }
    }
}

